/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.packets.SpawnEntity;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.AbstractMerchant;
import ovh.corail.tombstone.entity.ai.StayNearHome;
import ovh.corail.tombstone.entity.ai.spell.CurseSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellCastingGoal;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModEntities;

public final class GraveGuardian
extends AbstractMerchant
implements RangedAttackMob {
    @Nullable
    private GlobalPos homePos = null;

    public GraveGuardian(EntityType<? extends GraveGuardian> graveGuardianEntityType, Level level) {
        super(graveGuardianEntityType, level);
        this.m_274367_(1.0f);
        this.m_21553_(false);
    }

    public GraveGuardian(SpawnEntity ignoredSpawn, Level level) {
        this((EntityType<? extends GraveGuardian>)ModEntities.grave_guardian, level);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22285_, 1.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(4, new StayNearHome<GraveGuardian>(this, GraveGuardian::getHomePos, GraveGuardian::resetHomePos, 0.8));
        this.f_21345_.m_25352_(1, (Goal)new SpellCastingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CurseSpellGoal(this, new MobEffectInstance(ModEffects.frostbite, 200, 5)));
        this.f_21345_.m_25352_(4, (Goal)new CurseSpellGoal(this, new MobEffectInstance(MobEffects.f_216964_, 200, 5)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, EntityHelper::isEnemy));
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13080_) ? 5.0f : 0.0f;
    }

    public GlobalPos getHomePos() {
        if (this.homePos == null) {
            this.resetHomePos();
        }
        return this.homePos;
    }

    public void resetHomePos() {
        this.homePos = GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)this.m_20183_());
    }

    public void m_6043_() {
        if (!((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue()) {
            super.m_6043_();
        }
    }

    public boolean m_21532_() {
        return (Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get();
    }

    public boolean m_6785_(double distance) {
        return (Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get() == false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public void m_6504_(LivingEntity entity, float distance) {
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12451_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12453_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12452_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12454_, 0.15f, 1.0f);
    }

    public int m_8100_() {
        return 200;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    protected void m_7472_(DamageSource damageSource, int p_34175_, boolean p_34176_) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compound) {
        this.m_213945_(Helper.RANDOM_SOURCE, difficultyInstance);
        return groupData;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        ItemStack weapon = new ItemStack((ItemLike)Items.f_42393_);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        enchantments.put(ModEnchantments.magic_siphon, 5);
        enchantments.put(ModEnchantments.plague_bringer, 5);
        enchantments.put(Enchantments.f_44986_, 5);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)weapon);
        this.m_8061_(EquipmentSlot.MAINHAND, weapon);
        enchantments = new HashMap();
        enchantments.put(ModEnchantments.blessing, 5);
        enchantments.put(Enchantments.f_44986_, 5);
        ItemStack head = new ItemStack((ItemLike)Items.f_42480_);
        ItemStack chest = TimeHelper.isDateAroundHalloween() ? this.withTrimArmor(new ItemStack((ItemLike)Items.f_42481_)) : new ItemStack((ItemLike)Items.f_42481_);
        ItemStack leggings = new ItemStack((ItemLike)Items.f_42482_);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)head);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)chest);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)leggings);
        this.m_8061_(EquipmentSlot.HEAD, head);
        this.m_8061_(EquipmentSlot.CHEST, chest);
        this.m_8061_(EquipmentSlot.LEGS, leggings);
        ItemStack boots = new ItemStack((ItemLike)Items.f_42483_);
        enchantments.put(Enchantments.f_44976_, 3);
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)boots);
        this.m_8061_(EquipmentSlot.FEET, boots);
    }

    private ItemStack withTrimArmor(ItemStack armorStack) {
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        Optional material = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)new ItemStack((ItemLike)Items.f_42417_));
        Optional pattern = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)new ItemStack((ItemLike)Items.f_276537_));
        if (material.isPresent() && pattern.isPresent()) {
            ArmorTrim armorTrim = new ArmorTrim((Holder)material.get(), (Holder)pattern.get());
            ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)armorStack, (ArmorTrim)armorTrim);
        }
        return armorStack;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && !EffectHelper.isHarmful(effectInstance.m_19544_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && TimeHelper.atInterval(this.m_9236_(), 100)) {
            this.m_5634_(1.0f);
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.homePos != null) {
            NBTStackHelper.setLocation(compoundTag, "home_position", new Location(this.homePos));
        }
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        Location loc;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("home_position") && !(loc = NBTStackHelper.getLocation(compoundTag, "home_position")).isOrigin()) {
            this.homePos = loc.asGlobalPos();
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_6125_() {
        return false;
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }
}

