/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSounds;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityDecorativeGrave;

public final class BlockDecorativeGrave
extends BlockGraveBase {
    public static final EnumProperty<SoulType> SOUL_TYPE = EnumProperty.m_61587_((String)"soul_type", SoulType.class);

    public BlockDecorativeGrave(GraveModel graveModel) {
        super(BlockDecorativeGrave.getBuilder(), graveModel);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SOUL_TYPE, (Comparable)((Object)SoulType.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SOUL_TYPE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (!EntityHelper.isValidPlayer(playerIn) || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        ISoulConsumer soulConsumer = null;
        ItemStack stack = ItemStack.f_41583_;
        boolean isSoulReceptacle = playerIn.m_21205_().m_150930_((Item)ModItems.soul_receptacle);
        if (isSoulReceptacle) {
            stack = playerIn.m_21205_();
        } else {
            Optional optionalCap;
            Optional optionalCap2;
            ItemStack magicBookSlotContent;
            if (SupportMods.CURIOS.isLoaded() && !(magicBookSlotContent = CompatibilityCurio.instance.getStackInMagicBookSlot(playerIn)).m_41619_() && (optionalCap2 = magicBookSlotContent.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(ISoulConsumer::isUsingOffhandToEnchant)).isPresent()) {
                soulConsumer = (ISoulConsumer)optionalCap2.get();
                stack = magicBookSlotContent;
            }
            if (stack.m_41619_() && !playerIn.m_21206_().m_41619_() && (optionalCap = playerIn.m_21206_().getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(ISoulConsumer::isUsingOffhandToEnchant)).isPresent()) {
                soulConsumer = (ISoulConsumer)optionalCap.get();
                stack = playerIn.m_21206_();
            }
            if (stack.m_41619_() && !playerIn.m_21205_().m_41619_() && (optionalCap = playerIn.m_21205_().getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).filter(c -> true)).isPresent()) {
                if (((ISoulConsumer)optionalCap.get()).isUsingOffhandToEnchant()) {
                    if (!playerIn.m_9236_().m_5776_()) {
                        LangKey.MESSAGE_ENCHANT_WITH_OFFHAND.sendMessage(playerIn, new Object[0]);
                    }
                    return InteractionResult.FAIL;
                }
                soulConsumer = (ISoulConsumer)optionalCap.get();
                stack = playerIn.m_21205_();
            }
        }
        if (stack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (playerIn.m_9236_().m_5776_()) {
            return EntityHelper.noGlobalItemCooldown(playerIn, stack) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        if (!isSoulReceptacle && soulConsumer == null) {
            return InteractionResult.PASS;
        }
        if (EntityHelper.noGlobalItemCooldown((Player)serverPlayer, stack)) {
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
                if (((SoulType)((Object)state.m_61143_(SOUL_TYPE))).hasSoul()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendMessage((Player)serverPlayer, new Object[0]);
                    return InteractionResult.FAIL;
                }
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                if (bolt != null) {
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
                    bolt.m_20874_(true);
                    level.m_7967_((Entity)bolt);
                }
                level.m_7731_(pos, (BlockState)state.m_61124_(SOUL_TYPE, (Comparable)((Object)SoulType.WEAK)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendSpecialMessage((Player)serverPlayer, new Object[0]);
                if (!serverPlayer.m_7500_()) {
                    serverPlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
                serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, 10, (Integer)ConfigTombstone.alignment.pointsFreeSoulReceptacle.get()));
                ModTriggers.free_soul.trigger(serverPlayer);
                return InteractionResult.SUCCESS;
            }
            if (soulConsumer.isEnchanted(stack)) {
                LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendMessage((Player)serverPlayer, new Object[0]);
            } else {
                SoulType soulType = (SoulType)((Object)state.m_61143_(SOUL_TYPE));
                if (soulType.hasSoul()) {
                    int soulStrength = soulType.getSoulStrength();
                    if (soulConsumer.canEnchant(level, pos, (Player)serverPlayer, stack)) {
                        ISoulConsumer.ConsumeResult consumeResult = soulConsumer.setEnchant(level, pos, serverPlayer, stack, soulStrength);
                        if (consumeResult.result().success()) {
                            if (soulStrength == 2) {
                                if (consumeResult.soulStrength() == 1) {
                                    ModTriggers.knowledge_wasted.trigger(serverPlayer);
                                } else if (consumeResult.soulStrength() > 1) {
                                    ModTriggers.create_ancient_item.trigger(serverPlayer);
                                }
                            }
                            level.m_7731_(pos, (BlockState)state.m_61124_(SOUL_TYPE, (Comparable)((Object)soulType.consume(consumeResult.soulStrength()))), 3);
                            Helper.getDecorativeGrave(level, pos).ifPresent(BlockEntityDecorativeGrave::resetCheckSoul);
                            ModSounds.playSoundAllAround(ModSounds.MAGIC_USE01, SoundSource.PLAYERS, level, serverPlayer.m_20183_(), 0.5f, 0.5f);
                            LangKey.sendSystemMessage((Player)serverPlayer, consumeResult.message(), StyleType.MESSAGE_SPECIAL);
                            ModTriggers.consume_soul.trigger(serverPlayer);
                            int rewardKnowledge = soulConsumer.getKnowledge();
                            serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(serverPlayer, rewardKnowledge, 0));
                        } else {
                            LangKey.sendSystemMessage((Player)serverPlayer, consumeResult.message(), StyleType.COLOR_OFF);
                        }
                    } else {
                        LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendMessage((Player)serverPlayer, new Object[0]);
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendMessage((Player)serverPlayer, new Object[0]);
                }
            }
            EntityHelper.setGlobalItemCooldown((Player)serverPlayer, stack, 10);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemStack stack;
        if (entity.m_6144_() && entity.m_6084_() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((Player)entity).m_21205_()).m_41619_()) {
            stack.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).ifPresent(soulConsumer -> soulConsumer.onSneakGrave(level, pos, (Player)entity, stack));
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        String engraved_name;
        if (!level.m_5776_() && !(engraved_name = EngravableHelper.getEngravedName(stack)).isEmpty()) {
            Helper.getDecorativeGrave(level, pos).ifPresent(tile -> tile.setOwner(Optional.ofNullable(placer).filter(Player.class::isInstance).map(Player.class::cast).map(p -> p.m_36316_().getId()).orElse(null), engraved_name, TimeHelper.systemTime()));
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getExistingBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        BlockEntityDecorativeGrave decorativeGrave;
        BlockEntity blockEntity = blockGetter.getExistingBlockEntity(pos);
        return blockEntity instanceof BlockEntityDecorativeGrave && (decorativeGrave = (BlockEntityDecorativeGrave)blockEntity).isOwner(player) ? super.m_5880_(state, player, blockGetter, pos) : 0.0f;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest && Helper.getDecorativeGrave(level, pos).map(g -> g.isOwner(player)).orElse(false).booleanValue()) {
            level.m_5898_(player, 2001, pos, BlockDecorativeGrave.m_49956_((BlockState)state));
            if (!level.m_5776_()) {
                DeathHandler.INSTANCE.removeAndEmptyPlayerGrave(level, pos);
            }
            return true;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    protected void onDrop(Level level, BlockPos pos, BlockState oldState) {
        Helper.getDecorativeGrave(level, pos).ifPresent(grave -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)ItemBlockGrave.createDecorativeStack(this.graveModel, (Integer)oldState.m_61143_((Property)MODEL_TEXTURE), grave.getOwnerName())));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDecorativeGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockDecorativeGrave.createTickerHelper(entityType, ModBlocks.tile_decorative_grave, level.m_5776_() ? BlockEntityDecorativeGrave::clientTick : BlockEntityDecorativeGrave::serverTick);
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(20.0f, 1.8E7f).m_60953_(s -> 5).m_60918_(SoundType.f_56742_);
    }
}

