/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import tschipp.carryon.platform.Services;

public final class Matchables {
    private static float getValueFromStringOrDefault(String toGetFrom, String key, float defaultVal) {
        Optional<Float> val = Matchables.getValueFromString(toGetFrom, key);
        return val.orElse(Float.valueOf(defaultVal)).floatValue();
    }

    private static Optional<Float> getValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null || toGetFrom.isEmpty()) {
            return Optional.empty();
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            float numb = 0.0f;
            string = string.replace(key + "=", "");
            try {
                numb = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Optional.of(Float.valueOf(numb));
        }
        return Optional.empty();
    }

    public static class OptionalVec3 {
        public static final Codec<OptionalVec3> CODEC = Codec.STRING.xmap(OptionalVec3::new, OptionalVec3::source);
        public static final OptionalVec3 NONE = new OptionalVec3("");
        String source;
        Vec3 vec;
        boolean x;
        boolean y;
        boolean z;

        public OptionalVec3(String source) {
            this.source = source;
            Optional<Float> xOpt = Matchables.getValueFromString(source, "x");
            Optional<Float> yOpt = Matchables.getValueFromString(source, "y");
            Optional<Float> zOpt = Matchables.getValueFromString(source, "z");
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            if (xOpt.isPresent()) {
                x = xOpt.get().floatValue();
                this.x = true;
            }
            if (yOpt.isPresent()) {
                y = yOpt.get().floatValue();
                this.y = true;
            }
            if (zOpt.isPresent()) {
                z = zOpt.get().floatValue();
                this.z = true;
            }
            this.vec = new Vec3((double)x, (double)y, (double)z);
        }

        private String source() {
            return this.source;
        }

        public Vec3 getVec() {
            return this.vec;
        }

        public Vec3 getVec(double dX, double dY, double dZ) {
            double x = !this.x ? dX : this.vec.f_82479_;
            double y = !this.y ? dY : this.vec.f_82480_;
            double z = !this.z ? dZ : this.vec.f_82481_;
            return new Vec3(x, y, z);
        }
    }

    public record NBTCondition(CompoundTag tag) implements Matchable<CompoundTag>
    {
        public static final Codec<NBTCondition> CODEC = CompoundTag.f_128325_.xmap(NBTCondition::new, NBTCondition::tag);
        public static final NBTCondition NONE = new NBTCondition(new CompoundTag());

        @Override
        public boolean matches(CompoundTag other) {
            if (other == null) {
                return true;
            }
            return NbtUtils.m_129235_((Tag)this.tag, (Tag)other, (boolean)true);
        }
    }

    public record EffectsCondition(String effects) implements Matchable<ServerPlayer>
    {
        public static final Codec<EffectsCondition> CODEC = Codec.STRING.xmap(EffectsCondition::new, EffectsCondition::effects);
        public static final EffectsCondition NONE = new EffectsCondition("");

        @Override
        public boolean matches(ServerPlayer player) {
            int lev;
            if (this.effects == null || this.effects.isEmpty()) {
                return true;
            }
            Collection fx = player.m_21220_();
            String[] potions = this.effects.split(",");
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            for (String pot : potions) {
                if (pot.contains("#")) {
                    String level = pot.substring(pot.indexOf("#"));
                    String name = pot.substring(0, pot.indexOf("#"));
                    level = level.replace("#", "");
                    lev = 0;
                    try {
                        lev = Integer.parseInt(level);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    levels.add(lev);
                    names.add(name);
                    continue;
                }
                levels.add(0);
                names.add(pot);
            }
            int matches = 0;
            for (MobEffectInstance effect : fx) {
                int idx;
                int amp = effect.m_19564_();
                String name = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_()).toString();
                if (!names.contains(name) || (lev = ((Integer)levels.get(idx = names.indexOf(name))).intValue()) > amp) continue;
                ++matches;
            }
            return matches == potions.length;
        }
    }

    public record PositionCondition(String cond) implements Matchable<ServerPlayer>
    {
        public static final Codec<PositionCondition> CODEC = Codec.STRING.xmap(PositionCondition::new, PositionCondition::cond);
        public static final PositionCondition NONE = new PositionCondition("");

        @Override
        public boolean matches(ServerPlayer elem) {
            if (this.cond == null || this.cond.isEmpty()) {
                return true;
            }
            BlockPos blockpos = new BlockPos((int)Matchables.getValueFromStringOrDefault(this.cond, "x", 0.0f), (int)Matchables.getValueFromStringOrDefault(this.cond, "y", 0.0f), (int)Matchables.getValueFromStringOrDefault(this.cond, "z", 0.0f));
            BlockPos expand = new BlockPos((int)Matchables.getValueFromStringOrDefault(this.cond, "dx", 0.0f), (int)Matchables.getValueFromStringOrDefault(this.cond, "dy", 0.0f), (int)Matchables.getValueFromStringOrDefault(this.cond, "dz", 0.0f));
            BlockPos expanded = blockpos.m_121955_((Vec3i)expand);
            BlockPos pos = elem.m_20183_();
            boolean x = pos.m_123341_() >= blockpos.m_123341_() && pos.m_123341_() <= expanded.m_123341_() || blockpos.m_123341_() == 0;
            boolean y = pos.m_123342_() >= blockpos.m_123342_() && pos.m_123342_() <= expanded.m_123342_() || blockpos.m_123342_() == 0;
            boolean z = pos.m_123343_() >= blockpos.m_123343_() && pos.m_123343_() <= expanded.m_123343_() || blockpos.m_123343_() == 0;
            return x && y && z;
        }
    }

    public record ScoreboardCondition(String cond) implements Matchable<ServerPlayer>
    {
        public static final Codec<ScoreboardCondition> CODEC = Codec.STRING.xmap(ScoreboardCondition::new, ScoreboardCondition::cond);
        public static final ScoreboardCondition NONE = new ScoreboardCondition("");

        @Override
        public boolean matches(ServerPlayer player) {
            if (this.cond == null || this.cond.isEmpty()) {
                return true;
            }
            Scoreboard score = player.m_36329_();
            int iE = this.cond.indexOf("=");
            int iG = this.cond.indexOf(">");
            int iL = this.cond.indexOf("<");
            String numb = iG == -1 || iE < iG && iL == -1 || iE < iL && iE != -1 ? this.cond.substring(iE) : (iE == -1 || iG < iE && iL == -1 || iG < iL && iG != -1 ? this.cond.substring(iG) : this.cond.substring(iL));
            String scorename = this.cond.replace(numb, "");
            Object2IntMap scores = score.m_307827_((ScoreHolder)player);
            int scoreVal = scores.getInt((Object)score.m_83477_(scorename));
            return new NumberBoundCondition(numb).matches(scoreVal);
        }
    }

    public record GamestageCondition(String gamestage) implements Matchable<ServerPlayer>
    {
        public static final Codec<GamestageCondition> CODEC = Codec.STRING.xmap(GamestageCondition::new, GamestageCondition::gamestage);
        public static final GamestageCondition NONE = new GamestageCondition("");

        @Override
        public boolean matches(ServerPlayer player) {
            if (!Services.PLATFORM.isModLoaded("gamestages")) {
                return true;
            }
            if (this.gamestage == null || this.gamestage.isEmpty()) {
                return true;
            }
            return Services.GAMESTAGES.hasStage((Player)player, this.gamestage);
        }
    }

    public record AdvancementCondition(String advancement) implements Matchable<ServerPlayer>
    {
        public static final Codec<AdvancementCondition> CODEC = Codec.STRING.xmap(AdvancementCondition::new, AdvancementCondition::advancement);
        public static final AdvancementCondition NONE = new AdvancementCondition("");

        @Override
        public boolean matches(ServerPlayer player) {
            ServerAdvancementManager manager = player.f_8924_.m_129889_();
            AdvancementHolder adv = manager.m_294099_(new ResourceLocation(this.advancement.isEmpty() ? "" : this.advancement));
            boolean achievement = adv == null ? true : player.m_8960_().m_135996_(adv).m_8193_();
            return achievement;
        }
    }

    public record NumberBoundCondition(String bounds) implements Matchable<Number>
    {
        public static final Codec<NumberBoundCondition> CODEC = Codec.STRING.xmap(NumberBoundCondition::new, NumberBoundCondition::bounds);
        public static final NumberBoundCondition NONE = new NumberBoundCondition("");

        @Override
        public boolean matches(Number num) {
            double number = num.doubleValue();
            if (this.bounds == null || this.bounds.isEmpty()) {
                return true;
            }
            try {
                if (this.bounds.contains("<=")) {
                    return number <= Double.parseDouble(this.bounds.replace("<=", ""));
                }
                if (this.bounds.contains(">=")) {
                    return number >= Double.parseDouble(this.bounds.replace(">=", ""));
                }
                if (this.bounds.contains("<")) {
                    return number < Double.parseDouble(this.bounds.replace("<", ""));
                }
                if (this.bounds.contains(">")) {
                    return number > Double.parseDouble(this.bounds.replace(">", ""));
                }
                if (this.bounds.contains("=")) {
                    return number == Double.parseDouble(this.bounds.replace("=", ""));
                }
                return number == Double.parseDouble(this.bounds);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing Number bound for string: " + this.bounds + ". Error: " + e.getMessage());
            }
        }
    }

    public static interface Matchable<T> {
        public boolean matches(T var1);
    }
}

