/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.module;

import com.yungnickyoung.minecraft.betterfortresses.BetterFortressesCommon;
import com.yungnickyoung.minecraft.betterfortresses.config.BNFConfigForge;
import com.yungnickyoung.minecraft.betterfortresses.world.ItemFrameChances;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigModuleForge {
    public static final String CUSTOM_CONFIG_PATH = "betterfortresses";
    public static final String VERSION_PATH = "forge-1_20_4";

    public static void init() {
        ConfigModuleForge.initCustomFiles();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BNFConfigForge.SPEC, "betterfortresses-forge-1_20_4.toml");
        MinecraftForge.EVENT_BUS.addListener(ConfigModuleForge::onWorldLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigModuleForge::onConfigChange);
    }

    private static void onWorldLoad(LevelEvent.Load event) {
        ConfigModuleForge.bakeConfig();
        ConfigModuleForge.loadItemFramesJSON();
    }

    private static void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec() == BNFConfigForge.SPEC) {
            ConfigModuleForge.bakeConfig();
            ConfigModuleForge.loadItemFramesJSON();
        }
    }

    private static void initCustomFiles() {
        ConfigModuleForge.createDirectory();
        ConfigModuleForge.createBaseReadMe();
        ConfigModuleForge.createJsonReadMe();
        ConfigModuleForge.loadItemFramesJSON();
    }

    private static void createDirectory() {
        File parentDir = new File(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH);
        File customConfigDir = new File(parentDir, VERSION_PATH);
        try {
            String filePath = customConfigDir.getCanonicalPath();
            if (customConfigDir.mkdirs()) {
                BetterFortressesCommon.LOGGER.info("Creating directory for additional Better Nether Fortresses configuration at {}", (Object)filePath);
            }
        }
        catch (IOException e) {
            BetterFortressesCommon.LOGGER.error("ERROR creating Better Nether Fortresses config directory: {}", (Object)e.toString());
        }
    }

    private static void createBaseReadMe() {
        Path path = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "This directory is for a few additional options for YUNG's Better Nether Fortresses.\nOptions provided may vary by version.\nThis directory contains subdirectories for supported versions. The first time you run Better Nether Fortresses, a version subdirectory will be created if that version supports advanced options.\nFor example, the first time you use Better Nether Fortresses for MC 1.19.2 on Forge, the 'forge-1_19' subdirectory will be created in this folder.\nIf no subdirectory for your version is created, then that version probably does not support the additional options.\nNOTE -- Most of this mod's config settings can be found in a config file outside this folder!\nFor example, on Forge 1.19.2 the file is 'betterfortresses-forge-1_19.toml'.\nAlso note that many of the structure's settings such as spawn rate & spawn conditions can only be modified via data pack.";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create README file!");
            }
        }
    }

    private static void createJsonReadMe() {
        Path path = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "README.txt");
        File readme = new File(path.toString());
        if (!readme.exists()) {
            String readmeText = "######################################\n#          itemframes.json          #\n######################################\n  This file contains ItemRandomizers describing the probability distribution of items in item frames.\nItem frames only spawn in certain rooms and hallway pieces.\nFor information on ItemRandomizers, see the bottom of this README.\n######################################\n#         ItemRandomizers           #\n######################################\nDescribes a set of items and the probability of each item being chosen.\n - entries: An object where each entry's key is an item, and each value is that item's probability of being chosen.\n      The total sum of all probabilities SHOULD NOT exceed 1.0!\n - defaultItem: The item used for any leftover probability ranges.\n      For example, if the total sum of all the probabilities of the entries is 0.6, then\n      there is a 0.4 chance of the defaultItem being selected.\nHere's an example ItemRandomizer:\n{\n  \"entries\": {\n    \"minecraft:cobblestone\": 0.25,\n    \"minecraft:air\": 0.2,\n    \"minecraft:stone_sword\": 0.1\n  },\n  \"defaultItem\": \"minecraft:iron_axe\"\n}\nThis randomizer has a 25% chance of returning cobblestone, 20% chance of choosing air,\n10% chance of choosing a stone sword, and a 100 - (25 + 20 + 10) = 45% chance of choosing iron axe (since it's the default item).\n";
            try {
                Files.write(path, readmeText.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create item frames README file!");
            }
        }
    }

    private static void loadItemFramesJSON() {
        Path jsonPath = Paths.get(FMLPaths.CONFIGDIR.get().toString(), CUSTOM_CONFIG_PATH, VERSION_PATH, "itemframes.json");
        File jsonFile = new File(jsonPath.toString());
        if (!jsonFile.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)jsonPath, (Object)ItemFrameChances.get());
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Unable to create itemframes.json file: {}", (Object)e.toString());
            }
        } else {
            if (!jsonFile.canRead()) {
                BetterFortressesCommon.LOGGER.error("Better Nether Fortresses itemframes.json file not readable! Using default configuration...");
                return;
            }
            try {
                ItemFrameChances.instance = (ItemFrameChances)JSON.loadObjectFromJsonFile((Path)jsonPath, ItemFrameChances.class);
            }
            catch (IOException e) {
                BetterFortressesCommon.LOGGER.error("Error loading Better Nether Fortresses itemframes.json file: {}", (Object)e.toString());
                BetterFortressesCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static void bakeConfig() {
        BetterFortressesCommon.CONFIG.general.disableVanillaFortresses = (Boolean)BNFConfigForge.general.disableVanillaFortresses.get();
    }
}

