/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.network;

import com.illusivesoulworks.comforts.common.network.ComfortsPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SPacketPlaceBag {
    private final int entityId;
    private final InteractionHand hand;
    private final Direction direction;
    private final BlockPos blockPos;
    private final Vec3 location;
    private final boolean inside;

    public SPacketPlaceBag(int entityIdIn, InteractionHand hand, Vec3 location, Direction direction, BlockPos pos, boolean inside) {
        this.entityId = entityIdIn;
        this.hand = hand;
        this.direction = direction;
        this.location = location;
        this.blockPos = pos;
        this.inside = inside;
    }

    public static void encode(SPacketPlaceBag msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130068_((Enum)msg.hand);
        buf.m_269582_(msg.location.m_252839_());
        buf.m_130068_((Enum)msg.direction);
        buf.m_130064_(msg.blockPos);
        buf.writeBoolean(msg.inside);
    }

    public static SPacketPlaceBag decode(FriendlyByteBuf buf) {
        return new SPacketPlaceBag(buf.readInt(), (InteractionHand)buf.m_130066_(InteractionHand.class), new Vec3(buf.m_269394_()), (Direction)buf.m_130066_(Direction.class), buf.m_130135_(), buf.readBoolean());
    }

    public static void handle(SPacketPlaceBag msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId)) instanceof Player) {
                Player player = (Player)entity;
                ComfortsPackets.handlePlaceBag(player, msg.hand, new BlockHitResult(msg.location, msg.direction, msg.blockPos, msg.inside));
            }
        });
        ctx.setPacketHandled(true);
    }
}

