/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.DisplayableBoolean;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;

public class NewKeyBindsScreen
extends KeyBindsScreen {
    private AutoCompletingEditBox<KeyBindsList.Entry> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private Button buttonNone;
    private Button buttonConflicting;
    private Button buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, (Component)ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, (Component)ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    private final Button.OnPress PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = this;
        Minecraft minecraft = Objects.requireNonNull(screen.f_96541_);
        if (!this.confirmingReset.toggle()) {
            for (KeyMapping keybinding : minecraft.f_91066_.f_92059_) {
                Services.PLATFORM.setToDefault(minecraft.f_91066_, keybinding);
            }
            this.getKeyBindsList().m_269130_();
        }
        btn.m_93666_(this.confirmingReset.currentDisplay());
    };
    private final Button.OnPress PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonConflicting.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.m_93666_(this.sortOrder.getDisplay());
        this.filterKeys();
    };
    private final Button.OnPress PRESS_CONFLICTING = btn -> {
        if (this.displayMode == DisplayMode.CONFLICTING) {
            this.buttonConflicting.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.CONFLICTING;
            this.buttonConflicting.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonNone.m_93666_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        this.filterKeys();
    };
    private final Button.OnPress PRESS_FREE = btn -> {
        this.m_169411_((GuiEventListener)this.getKeyBindsList());
        if (this.showFree) {
            this.buttonSort.f_93623_ = true;
            this.buttonNone.f_93623_ = true;
            this.buttonConflicting.f_93623_ = true;
            this.resetButton().f_93623_ = this.canReset();
            this.setKeyBindsList(this.newKeyList.get());
        } else {
            this.freeKeyList.get().recalculate();
            this.buttonSort.f_93623_ = false;
            this.buttonNone.f_93623_ = false;
            this.buttonConflicting.f_93623_ = false;
            this.resetButton().f_93623_ = false;
            this.setKeyBindsList(this.freeKeyList.get());
        }
        this.filterKeys();
        this.m_142416_((GuiEventListener)this.getKeyBindsList());
        this.m_7522_((GuiEventListener)this.getKeyBindsList());
        this.showFree = !this.showFree;
    };

    public NewKeyBindsScreen(Screen screen, Options settings) {
        super(screen, settings);
    }

    protected void m_7856_() {
        super.m_7856_();
        int searchX = this.getKeyBindsList().m_5759_();
        int btnWidth = 74;
        int groupPadding = 5;
        int centerX = this.f_96543_ / 2;
        int leftX = centerX - 150 - groupPadding;
        int rightX = centerX + groupPadding;
        int bottomY = this.f_96544_ - 29;
        int rowSpacing = 24;
        int topRowY = bottomY - rowSpacing;
        Supplier<List> listSupplier = () -> this.getCustomList().getAllEntries();
        this.search = (AutoCompletingEditBox)this.m_142416_((GuiEventListener)new AutoCompletingEditBox(this.f_96547_, centerX - searchX / 2, 22, searchX, 20, this.search, (Component)Component.m_237115_((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier));
        this.search.addResponder(this::filterKeys);
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.f_96541_));
        this.freeKeyList = Suppliers.memoize(() -> new FreeKeysList(this, this.f_96541_));
        this.m_169411_((GuiEventListener)this.getKeyBindsList());
        this.setKeyBindsList(this.showFree ? (KeyBindsList)this.freeKeyList.get() : (KeyBindsList)this.newKeyList.get());
        this.m_142416_((GuiEventListener)this.getKeyBindsList());
        this.m_169411_((GuiEventListener)this.resetButton());
        this.resetButton((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.confirmingReset.currentDisplay(), (Button.OnPress)this.PRESS_RESET).m_252987_(leftX, bottomY, 150, 20).m_253136_()));
        this.resetButton().f_93623_ = this.canReset();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, (Button.OnPress)this.PRESS_FREE).m_252987_(leftX, topRowY, btnWidth, 20).m_253136_());
        this.buttonSort = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.sortOrder.getDisplay(), (Button.OnPress)this.PRESS_SORT).m_252987_(leftX + btnWidth + 2, topRowY, btnWidth, 20).m_253136_());
        this.buttonNone = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (Button.OnPress)this.PRESS_NONE).m_252987_(rightX, topRowY, btnWidth, 20).m_253136_());
        this.buttonConflicting = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, (Button.OnPress)this.PRESS_CONFLICTING).m_252987_(rightX + btnWidth + 2, topRowY, btnWidth, 20).m_253136_());
        this.displayMode = DisplayMode.ALL;
        this.m_264313_((GuiEventListener)this.search);
        this.search.m_94188_(0, false);
        this.m_6702_().sort(Comparator.comparingInt(value -> value.m_264198_().m_274449_()).thenComparingInt(listener -> listener.m_264198_().m_274563_()));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mxPos, int myPos, float partialTicks) {
        super.m_88315_(guiGraphics, mxPos, myPos, partialTicks);
        this.search.autoComplete().m_88315_(guiGraphics, mxPos, myPos, partialTicks);
    }

    public Button resetButton() {
        return this.getAccess().controlling$getResetButton();
    }

    public void resetButton(Button button) {
        this.getAccess().controlling$setResetButton(button);
    }

    public void filterKeys() {
        this.filterKeys(this.search.m_94155_());
    }

    public void filterKeys(String lastSearch) {
        this.getKeyBindsList().m_6702_().clear();
        this.getKeyBindsList().m_93410_(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.getKeyBindsList().m_6702_().addAll(this.getCustomList().getAllEntries());
            return;
        }
        Predicate<KeyBindsList.Entry> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        CustomList list = this.getCustomList();
        if (list instanceof NewKeyBindsList) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> this.sortOrder.sort((List<KeyBindsList.Entry>)entries);
        }
        list.m_6702_().addAll(ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.m_6702_());
    }

    public boolean m_6375_(double xpos, double ypos, int buttonId) {
        boolean b = super.m_6375_(xpos, ypos, buttonId);
        if (!b && this.search.m_93696_() && !this.search.autoComplete().m_6375_(xpos, ypos, buttonId)) {
            this.search.m_93692_(false);
            this.m_264131_();
            b = true;
        }
        return b;
    }

    public boolean m_6050_(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.search.autoComplete().m_6050_(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.m_6050_(xpos, ypos, xDelta, yDelta);
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (!this.search.m_93696_() && this.f_193975_ == null && NewKeyBindsScreen.m_96637_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)70)) {
            this.search.m_93692_(true);
            return true;
        }
        if (this.search.m_93696_() && key == 256) {
            this.search.m_93692_(false);
            return true;
        }
        if (this.f_193975_ != null) {
            if (key == 256) {
                Services.PLATFORM.setKey(this.f_96282_, this.f_193975_, InputConstants.f_84822_);
            } else {
                Services.PLATFORM.setKey(this.f_96282_, this.f_193975_, InputConstants.m_84827_((int)key, (int)scancode));
            }
            if (!Services.PLATFORM.isKeyCodeModifier(((AccessKeyMapping)this.f_193975_).controlling$getKey())) {
                this.f_193975_ = null;
            }
            this.f_193976_ = Util.m_137550_();
            this.getKeyBindsList().m_269130_();
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    private CustomList getCustomList() {
        KeyBindsList keyBindsList = this.getKeyBindsList();
        if (keyBindsList instanceof CustomList) {
            CustomList cl = (CustomList)keyBindsList;
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList().getClass()));
    }

    private KeyBindsList getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    private void setKeyBindsList(KeyBindsList newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }

    private boolean canReset() {
        for (KeyMapping key : this.f_96282_.f_92059_) {
            if (key.m_90864_()) continue;
            return true;
        }
        return false;
    }
}

