/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.api.events.IKeyEntryListenersEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseReleasedEvent;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.platform.Services;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.ArrayUtils;

public class NewKeyBindsList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;

    public NewKeyBindsList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93619_ -= 52;
        this.m_253211_(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        Object[] bindings = (KeyMapping[])ArrayUtils.clone((Object[])mcIn.f_91066_.f_92059_);
        Arrays.sort(bindings);
        String lastCategory = null;
        for (Object keybinding : bindings) {
            MutableComponent component;
            int width;
            String category = keybinding.m_90858_();
            if (!category.equals(lastCategory)) {
                lastCategory = category;
                if (!category.endsWith(".hidden")) {
                    this.addEntry(new CategoryEntry((Component)Component.m_237115_((String)category)));
                }
            }
            if ((width = mcIn.f_91062_.m_92852_((FormattedText)(component = Component.m_237115_((String)keybinding.m_90860_())))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if (category.endsWith(".hidden")) continue;
            this.addEntry(new KeyEntry((KeyMapping)keybinding, (Component)component));
        }
    }

    public int m_306468_() {
        return this.controlsScreen.f_96544_ - 56;
    }

    public int m_307439_() {
        return this.controlsScreen.f_96543_ + 45;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class CategoryEntry
    extends KeyBindsList.Entry
    implements ICategoryEntry {
        private final Component name;
        private final int labelWidth;

        public CategoryEntry(Component name) {
            this.name = name;
            this.labelWidth = NewKeyBindsList.this.mc.f_91062_.m_92852_((FormattedText)this.name);
        }

        public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.m_280430_(NewKeyBindsList.this.mc.f_91062_, this.name, Objects.requireNonNull(((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91080_).f_96543_ / 2 - this.labelWidth / 2, y + rowWidth - 9 - 1, 0xFFFFFF);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput neo) {
                    neo.m_169146_(NarratedElementType.TITLE, CategoryEntry.this.name);
                }
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        protected void m_264257_() {
        }

        @Override
        public Component name() {
            return this.name;
        }
    }

    public class KeyEntry
    extends KeyBindsList.Entry
    implements IKeyEntry {
        private final KeyMapping key;
        private final Component keyDesc;
        private final Button btnChangeKeyBinding;
        private final Button btnResetKeyBinding;
        private boolean hasCollision;
        private final Component categoryName;

        public KeyEntry(KeyMapping key, Component keyDesc) {
            this.key = key;
            this.keyDesc = keyDesc;
            this.btnChangeKeyBinding = Button.m_253074_((Component)this.keyDesc, btn -> {
                NewKeyBindsList.this.controlsScreen.f_193975_ = key;
                NewKeyBindsList.this.m_269130_();
            }).m_252987_(0, 0, 75, 20).m_252778_(supp -> key.m_90862_() ? Component.m_237110_((String)"narrator.controls.unbound", (Object[])new Object[]{keyDesc}) : Component.m_237110_((String)"narrator.controls.bound", (Object[])new Object[]{keyDesc, supp.get()})).m_253136_();
            this.btnResetKeyBinding = Button.m_253074_((Component)ControllingConstants.COMPONENT_CONTROLS_RESET, btn -> {
                Services.PLATFORM.setToDefault(((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91066_, key);
                NewKeyBindsList.this.m_269130_();
            }).m_252987_(0, 0, 50, 20).m_252778_(supp -> Component.m_237110_((String)"narrator.controls.reset", (Object[])new Object[]{keyDesc})).m_253136_();
            this.categoryName = Component.m_237115_((String)this.key.m_90858_());
            this.m_264257_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Services.EVENT.fireKeyEntryRenderEvent(this, guiGraphics, slotIndex, y, x, rowLeft, rowWidth, mouseX, mouseY, hovered, partialTicks);
            int length = Math.max(0, x + 90 - NewKeyBindsList.this.maxListLabelWidth);
            guiGraphics.m_280430_(NewKeyBindsList.this.mc.f_91062_, this.keyDesc, length, y + rowWidth / 2 - 4, 0xFFFFFF);
            this.btnResetKeyBinding.m_252865_(x + 190 + 20);
            this.btnResetKeyBinding.m_253211_(y);
            this.btnResetKeyBinding.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.btnChangeKeyBinding.m_252865_(x + 105);
            this.btnChangeKeyBinding.m_253211_(y);
            if (this.hasCollision) {
                int markerWidth = 3;
                int minX = this.btnChangeKeyBinding.m_252754_() - 6;
                guiGraphics.m_280509_(minX, y + 2, minX + markerWidth, y + rowWidth + 2, ChatFormatting.RED.m_126665_() | 0xFF000000);
            }
            this.btnChangeKeyBinding.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public List<GuiEventListener> m_6702_() {
            return (List)Services.EVENT.fireKeyEntryListenersEvent(this).map(IKeyEntryListenersEvent::getListeners, UnaryOperator.identity());
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.btnChangeKeyBinding, (Object)this.btnResetKeyBinding);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int buttonId) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseClickedEvent(this, mouseX, mouseY, buttonId).map(IKeyEntryMouseClickedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, buttonId);
        }

        @Override
        public boolean m_6348_(double mouseX, double mouseY, int buttonId) {
            if (((Boolean)Services.EVENT.fireKeyEntryMouseReleasedEvent(this, mouseX, mouseY, buttonId).map(IKeyEntryMouseReleasedEvent::isHandled, UnaryOperator.identity())).booleanValue()) {
                return true;
            }
            return super.m_6348_(mouseX, mouseY, buttonId);
        }

        @Override
        public KeyMapping getKey() {
            return this.key;
        }

        @Override
        public Component getKeyDesc() {
            return this.keyDesc;
        }

        @Override
        public Component categoryName() {
            return this.categoryName;
        }

        @Override
        public Button getBtnResetKeyBinding() {
            return this.btnResetKeyBinding;
        }

        @Override
        public Button getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }

        protected void m_264257_() {
            this.btnChangeKeyBinding.m_93666_(this.key.m_90863_());
            this.btnResetKeyBinding.f_93623_ = !this.key.m_90864_();
            this.hasCollision = false;
            MutableComponent duplicates = Component.m_237119_();
            if (!this.key.m_90862_()) {
                KeyMapping[] mappings;
                for (KeyMapping mapping : mappings = ((NewKeyBindsList)NewKeyBindsList.this).f_93386_.f_91066_.f_92059_) {
                    if ((mapping == this.key || !this.key.m_90850_(mapping)) && !Services.PLATFORM.hasConflictingModifier(this.key, mapping)) continue;
                    if (this.hasCollision) {
                        duplicates.m_130946_(", ");
                    }
                    this.hasCollision = true;
                    duplicates.m_7220_((Component)Component.m_237115_((String)mapping.m_90860_()));
                }
            }
            MutableComponent tooltip = Component.m_237115_((String)this.key.m_90858_());
            if (this.hasCollision) {
                this.btnChangeKeyBinding.m_93666_((Component)Component.m_237113_((String)"[ ").m_7220_((Component)this.btnChangeKeyBinding.m_6035_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_130946_(" ]").m_130940_(ChatFormatting.RED));
                tooltip.m_7220_(CommonComponents.f_178388_);
                tooltip.m_7220_((Component)Component.m_237110_((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{duplicates}));
            }
            this.btnChangeKeyBinding.m_257544_(Tooltip.m_257550_((Component)tooltip));
            if (NewKeyBindsList.this.controlsScreen.f_193975_ == this.key) {
                this.btnChangeKeyBinding.m_93666_((Component)Component.m_237113_((String)"> ").m_7220_((Component)this.btnChangeKeyBinding.m_6035_().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})).m_130946_(" <").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

