/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.IInputEntry;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.mixin.AccessInputConstantsKey;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;

public class FreeKeysList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    private final List<KeyMapping> keyBindings;

    public FreeKeysList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.f_93619_ -= 52;
        this.m_253211_(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.m_6702_().clear();
        this.allEntries = new ArrayList();
        this.keyBindings = Arrays.stream(this.mc.f_91066_.f_92059_).collect(Collectors.toList());
        this.recalculate();
    }

    public int m_306468_() {
        return this.controlsScreen.f_96544_ - 56;
    }

    public int m_307439_() {
        return this.controlsScreen.f_96543_ + 45;
    }

    public void recalculate() {
        this.m_6702_().clear();
        this.allEntries.clear();
        this.addEntry(new HeaderEntry("Available Keys"));
        AccessInputConstantsKey.controlling$getNAME_MAP().values().stream().filter(input -> !input.m_84874_().startsWith("key.keyboard.world")).filter(Predicate.not(arg_0 -> ((InputConstants.Key)InputConstants.f_84822_).equals(arg_0))).sorted(Comparator.comparing(o -> o.m_84875_().getString())).forEach(input -> {
            if (this.keyBindings.stream().noneMatch(keyBinding -> ((AccessKeyMapping)keyBinding).controlling$getKey().equals(input))) {
                int i = this.mc.f_91062_.m_92895_(input.m_84875_().getString());
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
                this.addEntry(new InputEntry((InputConstants.Key)input));
            }
        });
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public class HeaderEntry
    extends KeyBindsList.Entry {
        private final String text;

        public HeaderEntry(String text) {
            this.text = text;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.m_280653_(FreeKeysList.this.mc.f_91062_, (Component)ControllingConstants.COMPONENT_OPTIONS_AVAILABLE_KEYS, Objects.requireNonNull(FreeKeysList.this.mc.f_91080_).f_96543_ / 2 - this.text.length() / 2, y + height - 9 - 1, 0xFFFFFF);
        }

        protected void m_264257_() {
        }
    }

    public class InputEntry
    extends KeyBindsList.Entry
    implements IInputEntry {
        private final InputConstants.Key input;

        public InputEntry(InputConstants.Key input) {
            this.input = input;
        }

        @Override
        public InputConstants.Key getInput() {
            return this.input;
        }

        public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            String str = this.input.toString() + " - " + this.input.m_84873_();
            int length = FreeKeysList.this.mc.f_91062_.m_92895_(this.input.m_84875_().getString());
            guiGraphics.m_280488_(FreeKeysList.this.mc.f_91062_, str, x, y + height / 2 - 4, 0xFFFFFF);
            guiGraphics.m_280557_(FreeKeysList.this.mc.f_91062_, this.input.m_84875_(), x + width - length, y + height);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        protected void m_264257_() {
        }
    }
}

