/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.Constants;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.data.BetterStatus;
import dev.wuffs.bcc.data.BetterStatusServerHolder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="bcc")
public class BCCForge {
    public BCCForge() {
        Constants.LOG.info("Better Compatibility Checker starting");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonSetup);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "SERVER_ONLY", (a, b) -> true));
    }

    private void doCommonSetup(FMLCommonSetupEvent event) {
        Constants.LOG.info("Better Compatibility Checker setup");
        if (((Boolean)Config.useMetadata.get()).booleanValue()) {
            Path metaFile = FMLPaths.CONFIGDIR.get().resolve("metadata.json");
            if (!Files.exists(metaFile, new LinkOption[0])) {
                Constants.LOG.error("No metadata.json found, falling back to config values");
            } else {
                try {
                    Constants.LOG.info("Loading metadata.json");
                    Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                    BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus(metadata.id, metadata.name, metadata.version.name, metadata.version.id, metadata.version.type, true));
                    return;
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to read metadata.json", (Throwable)e);
                }
            }
        }
        BetterStatusServerHolder.INSTANCE.setStatus(new BetterStatus((Integer)Config.modpackProjectID.get(), (String)Config.modpackName.get(), (String)Config.modpackVersion.get(), -1, "unknown", false));
    }
}

