/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block.entity;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.CommonAbstractions;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.barteringstation.world.level.block.entity.BarteringStationAnimationController;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerImpl;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BarteringStationBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
ContainerImpl,
TickingBlockEntity {
    public static final MutableComponent CONTAINER_BARTERING_STATION = Component.m_237115_((String)"container.bartering_station");
    public static final String TAG_DELAY = BarteringStation.id("delay").toString();
    public static final int ALL_SLOTS = 21;
    public static final int CURRENCY_SLOTS = 6;
    public static final int DATA_SLOTS = 2;
    private static final int[] SLOTS_FOR_INPUT = (int[])Util.m_137469_((Object)new int[6], arr -> Arrays.setAll(arr, IntUnaryOperator.identity()));
    private static final int[] SLOTS_FOR_OUTPUT = (int[])Util.m_137469_((Object)new int[15], arr -> Arrays.setAll(arr, i -> i + 6));
    private final BarteringStationAnimationController animationController;
    private final ContainerData dataAccess;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)21, (Object)ItemStack.f_41583_);
    private int barterDelay;
    private int nearbyPiglins;

    public BarteringStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.m_203334_(), blockPos, blockState);
        this.animationController = new BarteringStationAnimationController(blockPos);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> BarteringStationBlockEntity.this.getBarterDelay();
                    case 1 -> BarteringStationBlockEntity.this.nearbyPiglins;
                    default -> throw new IndexOutOfBoundsException(id);
                };
            }

            public void m_8050_(int id, int data) {
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public int getBarterDelay() {
        return Math.min(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay, this.barterDelay);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.barterDelay = tag.m_128448_(TAG_DELAY);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_(TAG_DELAY, (short)this.barterDelay);
    }

    protected Component m_6820_() {
        return CONTAINER_BARTERING_STATION;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new BarteringStationMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public void clientTick() {
        this.animationController.tick(this.m_58904_());
    }

    public void serverTick() {
        int totalBarterDelay;
        boolean tryPerformBarter;
        if (this.barterDelay > 0) {
            --this.barterDelay;
        }
        boolean bl = tryPerformBarter = this.barterDelay % (totalBarterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay) == 0;
        if (tryPerformBarter || this.barterDelay % (totalBarterDelay / 4) == 0) {
            List<Piglin> piglins = BarteringStationBlockEntity.findNearbyPiglins(this.m_58904_(), this.m_58899_());
            this.nearbyPiglins = piglins.size();
            if (tryPerformBarter) {
                this.barterDelay = totalBarterDelay * 2;
                this.barterWithPiglins(this.m_58899_(), piglins);
            }
        }
    }

    private static List<Piglin> findNearbyPiglins(Level level, BlockPos pos) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int horizontalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).horizontalRange;
        int verticalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).verticalRange;
        return level.m_6443_(Piglin.class, new AABB(vec3.m_82520_((double)(-horizontalRange), (double)(-verticalRange), (double)(-horizontalRange)), vec3.m_82520_((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), AbstractPiglin::m_34667_);
    }

    private void barterWithPiglins(BlockPos pos, List<Piglin> piglins) {
        if (piglins.isEmpty() || this.findFreeResponseSlot().isEmpty()) {
            return;
        }
        int currentPiglin = 0;
        block0: for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            while (currentPiglin < piglins.size()) {
                if (!BarteringStationBlockEntity.mobInteract(piglins.get(currentPiglin++), stack, pos)) continue;
                this.m_6596_();
                this.barterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
                continue block0;
            }
        }
    }

    private OptionalInt findFreeResponseSlot() {
        for (int i = 6; i < this.m_6643_(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private static boolean mobInteract(Piglin piglin, ItemStack itemStack, BlockPos blockPos) {
        if (PiglinAi.m_34909_((Piglin)piglin, (ItemStack)itemStack)) {
            ItemStack currencyStack = itemStack.m_41620_(1);
            PiglinAi.m_34932_((Piglin)piglin, (ItemStack)currencyStack);
            BarteringStationBlockEntity.admireGoldItem((LivingEntity)piglin);
            PiglinAi.m_35006_((Piglin)piglin);
            ((BarteringStationCapability)ModRegistry.BARTERING_STATION_CAPABILITY.get((Object)piglin)).setBarteringStationPos(blockPos);
            return true;
        }
        return false;
    }

    private static void admireGoldItem(LivingEntity livingEntity) {
        livingEntity.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, (long)(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay / 2));
    }

    public BarteringStationAnimationController getAnimationController() {
        return this.animationController;
    }

    public int[] m_7071_(Direction direction) {
        return direction == Direction.DOWN ? SLOTS_FOR_OUTPUT : SLOTS_FOR_INPUT;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack itemStack, Direction direction) {
        return true;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index >= 0 && index < 6 && CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
    }

    public boolean placeBarterResponseItem(ItemStack stack) {
        while (!stack.m_41619_()) {
            OptionalInt slot = this.findResponseSlotWithSpace(stack);
            if (slot.isEmpty()) {
                slot = this.findFreeResponseSlot();
            }
            if (!slot.isPresent()) break;
            this.mergeStackToSlot(stack, slot.getAsInt());
            if (!stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private OptionalInt findResponseSlotWithSpace(ItemStack stack) {
        for (int i = 6; i < this.m_6643_(); ++i) {
            if (!this.hasSpaceForItem(this.m_8020_(i), stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void mergeStackToSlot(ItemStack stackToMerge, int targetSlot) {
        ItemStack stackToInsert;
        ItemStack stackInSlot = this.m_8020_(targetSlot);
        if (stackInSlot.m_41619_()) {
            stackToInsert = stackToMerge.m_41777_();
            stackToMerge.m_41764_(0);
            if (stackToMerge.m_41782_()) {
                stackToInsert.m_41751_(stackToMerge.m_41783_().m_6426_());
            }
        } else {
            stackToInsert = stackInSlot.m_41777_();
            int transferAmount = stackToMerge.m_41613_();
            transferAmount = Math.min(transferAmount, stackToInsert.m_41741_() - stackToInsert.m_41613_());
            stackToInsert.m_41769_(transferAmount);
            stackToMerge.m_41774_(transferAmount);
        }
        this.m_6836_(targetSlot, stackToInsert);
    }

    private boolean hasSpaceForItem(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2) && stack1.m_41753_() && stack1.m_41613_() < stack1.m_41741_() && stack1.m_41613_() < this.m_6893_();
    }
}

