/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.barteringstation.world.level.block.entity.BarteringStationAnimationController;
import fuzs.barteringstation.world.level.block.entity.BarteringStationBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BarteringStationRenderer
implements BlockEntityRenderer<BarteringStationBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BarteringStationRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(BarteringStationBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        packedLight = blockEntity.m_58904_() != null ? LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_7494_()) : 0xF000F0;
        BarteringStationAnimationController animationController = blockEntity.getAnimationController();
        float ageInTicks = (float)animationController.time + partialTick;
        float nextRotation = animationController.rot - animationController.oRot;
        while ((double)nextRotation >= Math.PI) {
            nextRotation -= (float)Math.PI * 2;
        }
        while ((double)nextRotation < -Math.PI) {
            nextRotation += (float)Math.PI * 2;
        }
        float bookRotation = animationController.oRot + nextRotation * partialTick;
        float bookOpen = Mth.m_14179_((float)partialTick, (float)animationController.oOpen, (float)animationController.open);
        this.renderItem(new ItemStack((ItemLike)Items.f_42417_), ageInTicks, bookOpen, bookRotation, poseStack, multiBufferSource, packedLight, packedOverlay, blockEntity.m_58904_());
    }

    private void renderItem(ItemStack itemStack, float ageInTicks, float bookOpen, float bookRotation, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay, Level level) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.03125f, 0.5f);
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        bookRotation *= -57.295776f;
        bookRotation -= 90.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(bookRotation *= bookOpen));
        poseStack.m_85837_(0.0, (double)bookOpen, Math.sin((double)bookOpen * Math.PI));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f * (bookOpen - 1.0f)));
        float hoveringHeight = (float)Math.sin(ageInTicks * 0.06f) * bookOpen * 0.2f;
        poseStack.m_252880_(0.0f, hoveringHeight, 0.0f);
        this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, multiBufferSource, level, 0);
        poseStack.m_85849_();
    }
}

