/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.client.handler.PiglinHeadModelRenderer;
import fuzs.barteringstation.config.ClientConfig;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BarteringStationScreen
extends AbstractContainerScreen<BarteringStationMenu> {
    public static final ResourceLocation BARTERING_STATION_LOCATION = BarteringStation.id("textures/gui/container/bartering_station.png");
    public static final int ARROW_SIZE_X = 24;
    public static final int ARROW_SIZE_Y = 18;
    private SkullModelBase skullModel;

    public BarteringStationScreen(BarteringStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    private static MutableComponent makePiglinComponent(int nearbyPiglins) {
        return Component.m_237113_((String)String.valueOf(nearbyPiglins)).m_130940_(nearbyPiglins > 0 ? ChatFormatting.GOLD : ChatFormatting.RED);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.skullModel = new SkullModel(this.f_96541_.m_167973_().m_171103_(PiglinHeadModelRenderer.PIGLIN_HEAD_MODEL_LAYER_LOCATION));
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.overlay()) {
            this.renderCooldownOverlays(guiGraphics);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int startX = this.f_97735_ + 53;
        int startY = this.f_97736_ + 20;
        if (startX <= mouseX && startY <= mouseY && mouseX < startX + 16 && mouseY < startY + 16) {
            MutableComponent component = Component.m_237110_((String)"gui.barteringstation.bartering_station.piglins", (Object[])new Object[]{BarteringStationScreen.makePiglinComponent(((BarteringStationMenu)this.f_97732_).getNearbyPiglins())});
            guiGraphics.m_280557_(this.f_96547_, (Component)component, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(BARTERING_STATION_LOCATION, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.arrows()) {
            this.renderCooldownArrows(guiGraphics);
        }
        this.renderPiglinHead(53, 20, 150);
        this.decoratePiglinHead(53, 20, 150);
    }

    private void renderPiglinHead(int posX, int posY, int blitOffset) {
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        PiglinHeadModelRenderer.INSTANCE.renderPiglinHeadGuiModel(posX, posY, blitOffset, this.skullModel);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
    }

    private void decoratePiglinHead(int posX, int posY, int blitOffset) {
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_((double)this.f_97735_, (double)this.f_97736_, (double)blitOffset + 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent component = BarteringStationScreen.makePiglinComponent(((BarteringStationMenu)this.f_97732_).getNearbyPiglins());
        this.f_96547_.m_272077_((Component)component, (float)(posX + 19 - 2 - this.f_96547_.m_92852_((FormattedText)component)), (float)(posY + 6 + 3), -1, true, posestack.m_85850_().m_252922_(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    private void renderCooldownArrows(GuiGraphics guiGraphics) {
        int arrow1Progress = ((BarteringStationMenu)this.f_97732_).getTopArrowProgress();
        guiGraphics.m_280218_(BARTERING_STATION_LOCATION, this.f_97735_ + 49, this.f_97736_ + 40, 176, 0, arrow1Progress, 18);
        int arrow2Progress = ((BarteringStationMenu)this.f_97732_).getBottomArrowProgress();
        guiGraphics.m_280218_(BARTERING_STATION_LOCATION, this.f_97735_ + 49 + 24 - arrow2Progress, this.f_97736_ + 53, 200 - arrow2Progress, 18, arrow2Progress, 18);
    }

    private void renderCooldownOverlays(GuiGraphics guiGraphics) {
        float cooldownProgress = ((BarteringStationMenu)this.f_97732_).getCooldownProgress();
        if (cooldownProgress > 0.0f && cooldownProgress < 1.0f) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 6 && i < ((BarteringStationMenu)this.f_97732_).f_38839_.size(); ++i) {
                Slot slot = (Slot)((BarteringStationMenu)this.f_97732_).f_38839_.get(i);
                if (!slot.m_6659_() || !slot.m_6657_()) continue;
                int startY = Mth.m_14143_((float)(16.0f * (1.0f - cooldownProgress)));
                guiGraphics.m_285944_(RenderType.m_286086_(), slot.f_40220_, slot.f_40221_ + startY, slot.f_40220_ + 16, slot.f_40221_ + startY + Mth.m_14167_((float)(16.0f * cooldownProgress)), -2130706433);
            }
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.enableDepthTest();
        }
    }
}

