/*
 * Decompiled with CFR 0.152.
 */
package forge.com.lupin.dangerclose.util;

import crystalspider.soulfired.api.type.FireTyped;
import forge.com.lupin.dangerclose.CommonClass;
import forge.com.lupin.dangerclose.ForgeExampleMod;
import forge.com.lupin.dangerclose.optional.SoulFired;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DangerClose {
    private static final boolean shouldDetect = CommonClass.ENABLE_DANGER_CLOSE;
    private static final boolean shouldTorchImmolate = CommonClass.TORCHES_BURN;
    private static final boolean shouldSoulTorchImmolate = CommonClass.SOUL_TORCHES_BURN;
    private static final boolean shouldCampfireImmolate = CommonClass.CAMPFIRES_BURN;
    private static final boolean shouldSoulCampfireImmolate = CommonClass.SOUL_CAMPFIRES_BURN;
    private static final boolean shouldStonecutterCut = CommonClass.STONECUTTERS_CUT;
    private static final boolean shouldMagmaBlockImmolate = CommonClass.ENABLE_MAGMA_BLOCK_DAMAGE;
    private static final boolean shouldBlazeImmolate = CommonClass.ENABLE_BLAZE_DAMAGE;
    private static final boolean shouldMagmaCubeImmolate = CommonClass.ENABLE_MAGMA_CUBE_DAMAGE;

    private static void immolate(LivingEntity entity) {
        entity.m_20254_(2);
    }

    private static void immolate(LivingEntity entity, boolean isSoulFire) {
        if (ForgeExampleMod.SOULFIRED_INSTALLED) {
            if (isSoulFire) {
                SoulFired.setOnSoulFire((Entity)entity, 2);
            } else {
                SoulFired.setOnRegularFire((Entity)entity, 2);
            }
            return;
        }
        DangerClose.immolate(entity);
    }

    private static void spreadFire(LivingEntity pLiving0, LivingEntity pLiving1) {
        if (pLiving1.m_6060_() && !pLiving0.m_6060_()) {
            if (ForgeExampleMod.SOULFIRED_INSTALLED) {
                SoulFired.setOnTypedFire((Entity)pLiving0, 2, ((FireTyped)pLiving1).getFireType());
                return;
            }
            DangerClose.immolate(pLiving0);
        } else if (pLiving0.m_6060_() && !pLiving1.m_6060_()) {
            if (ForgeExampleMod.SOULFIRED_INSTALLED) {
                SoulFired.setOnTypedFire((Entity)pLiving1, 2, ((FireTyped)pLiving0).getFireType());
                return;
            }
            DangerClose.immolate(pLiving1);
        }
        if (shouldBlazeImmolate && pLiving1 instanceof Blaze || shouldMagmaCubeImmolate && pLiving1 instanceof MagmaCube) {
            DangerClose.immolate(pLiving0);
        }
    }

    public static void detect(ServerLevel level, LivingEntity entity) {
        if (shouldDetect && level != null && entity != null) {
            List nearby = level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, entity, entity.m_20191_());
            for (LivingEntity pLiving1 : nearby) {
                DangerClose.spreadFire(entity, pLiving1);
            }
            if (entity.m_20096_()) {
                BlockPos pos = entity.m_20183_();
                BlockState insideBlockState = level.m_8055_(pos);
                Stream insideBlockTagStream = insideBlockState.m_204343_();
                Stream belowBlockTagStream = level.m_8055_(pos.m_7495_()).m_204343_();
                ArrayList insideReStreamable = new ArrayList();
                ArrayList belowReStreamable = new ArrayList();
                insideBlockTagStream.forEach(insideReStreamable::add);
                belowBlockTagStream.forEach(belowReStreamable::add);
                if (shouldTorchImmolate && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.TORCH_BURN_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.TORCH_BURN_DANGER)))) {
                    DangerClose.immolate(entity);
                } else if (shouldSoulTorchImmolate && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.SOUL_TORCH_BURN_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.SOUL_TORCH_BURN_DANGER)))) {
                    DangerClose.immolate(entity, true);
                }
                if (shouldCampfireImmolate && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.CAMPFIRE_BURN_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.CAMPFIRE_BURN_DANGER)))) {
                    if (insideBlockState.m_61138_((Property)CampfireBlock.f_51227_) && ((Boolean)insideBlockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                        DangerClose.immolate(entity);
                    }
                } else if (shouldSoulCampfireImmolate && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.SOUL_CAMPFIRE_BURN_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.SOUL_CAMPFIRE_BURN_DANGER))) && insideBlockState.m_61138_((Property)CampfireBlock.f_51227_) && ((Boolean)insideBlockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                    DangerClose.immolate(entity, true);
                }
                if (shouldStonecutterCut && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.STONECUTTER_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.STONECUTTER_DANGER)))) {
                    entity.m_6469_(level.m_269111_().m_269325_(), 4.0f);
                }
                if (shouldMagmaBlockImmolate && (insideReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.MAGMA_BURN_DANGER)) || belowReStreamable.stream().anyMatch(Predicate.isEqual(CommonClass.MAGMA_BURN_DANGER))) && !insideBlockState.m_60734_().m_7705_().toLowerCase().contains("cauldron")) {
                    DangerClose.immolate(entity);
                }
            }
        }
    }
}

