/*
 * Decompiled with CFR 0.152.
 */
package common.com.lupin.dangerclose.util;

import com.mojang.logging.LogUtils;
import common.com.lupin.dangerclose.CommonConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class CommonConfigIO {
    public static final String FILE_PATH = "config/dangerclose.properties";
    private static final Logger LOG = LogUtils.getLogger();

    public static void initializeConfiguration() {
        try {
            File file;
            File directory = new File("config");
            if (!directory.isDirectory()) {
                directory.mkdir();
            }
            if (!(file = new File(FILE_PATH)).isFile()) {
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (Map.Entry<String, Boolean> pair : CommonConstants.DEFAULT_CONFIGURATION.entrySet()) {
                    writer.write(pair.getKey() + "=" + pair.getValue() + "\n");
                }
            }
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
    }

    public static Map<String, Boolean> readConfigurationFromFile() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try (BufferedReader reader = new BufferedReader(new FileReader(FILE_PATH));){
            String line;
            int index = 1;
            while ((line = reader.readLine()) != null) {
                if (!line.isEmpty() && !line.isBlank()) {
                    if (!line.contains("=")) {
                        throw new IOException("dangerclose.properties contains an error on Line " + index + "! Line does not contain '='?");
                    }
                } else {
                    throw new IOException("dangerclose.properties contains an error on Line " + index + "! Line is empty or blank?");
                }
                String[] pair = line.split("\\=", 2);
                map.put(pair[0], Boolean.parseBoolean(pair[1]));
                ++index;
            }
        }
        catch (IOException e) {
            LOG.info("dangerclose.properties was unable to be read as plaintext or contains errors!");
            LOG.info(e.getMessage());
        }
        return map;
    }
}

