/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sparky.multirecipe.PolymorphConstants;
import com.sparky.multirecipe.mixin.core.AccessorSmithingTransformRecipe;
import com.sparky.multirecipe.mixin.core.AccessorSmithingTrimRecipe;
import com.sparky.multirecipe.platform.Services;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;

public class PolymorphCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"multirecipe").requires(player -> player.m_6761_(2));
        command.then(Commands.m_82127_((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((CommandSourceStack)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(CommandSourceStack source) {
        CompletableFuture.runAsync(() -> {
            source.m_288197_(() -> Component.m_237115_((String)"commands.multirecipe.conflicts.starting"), true);
            ServerLevel world = source.m_81372_();
            RecipeManager recipeManager = world.m_7465_();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            count += PolymorphCommands.scanRecipes(RecipeType.f_44107_, output, recipeManager, CraftingRecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44108_, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44109_, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44110_, output, recipeManager, RecipeWrapper::new);
            if ((count += PolymorphCommands.scanRecipes(RecipeType.f_44113_, output, recipeManager, SmithingRecipeWrapper::new)) > 0) {
                try {
                    Files.write(Paths.get(Services.PLATFORM.getGameDir() + "/logs/conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphConstants.LOG.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            int finalCount = count;
            source.m_288197_(() -> Component.m_237110_((String)"commands.multirecipe.conflicts.success", (Object[])new Object[]{finalCount}), true);
        });
        return 1;
    }

    private static <C extends Container, T extends Recipe<C>> int scanRecipes(RecipeType<T> pType, List<String> pOutput, RecipeManager pRecipeManager, Function<RecipeHolder<?>, RecipeWrapper> pFactory) {
        List<RecipeWrapper> recipes = pRecipeManager.m_44013_(pType).stream().map(pFactory).toList();
        ArrayList conflicts = new ArrayList();
        TreeSet<ResourceLocation> skipped = new TreeSet<ResourceLocation>();
        HashSet<ResourceLocation> processed = new HashSet<ResourceLocation>();
        for (RecipeWrapper recipe : recipes) {
            ResourceLocation resourceLocation = recipe.id();
            if (processed.contains(resourceLocation)) continue;
            processed.add(resourceLocation);
            if (recipe.getRecipe().f_291008_() instanceof CustomRecipe) {
                skipped.add(resourceLocation);
                continue;
            }
            TreeSet<ResourceLocation> currentGroup = new TreeSet<ResourceLocation>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.id()) || !otherRecipe.conflicts(recipe)) continue;
                currentGroup.add(resourceLocation);
                currentGroup.add(otherRecipe.id());
                processed.add(otherRecipe.id());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(BuiltInRegistries.f_256990_.m_7981_(pType) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(ResourceLocation::toString).forEach(joiner::add);
            pOutput.add(count + ": " + joiner);
            pOutput.add("");
            ++count;
        }
        if (skipped.size() > 0) {
            pOutput.add("Skipped special recipes: ");
            for (ResourceLocation resourceLocation : skipped) {
                pOutput.add(resourceLocation.toString());
            }
            pOutput.add("");
        }
        return conflicts.size();
    }

    private static class RecipeWrapper {
        private final RecipeHolder<?> recipe;
        private final List<IngredientWrapper> ingredients;

        private RecipeWrapper(RecipeHolder<?> pRecipe) {
            this.recipe = pRecipe;
            this.ingredients = new ArrayList<IngredientWrapper>();
            for (Ingredient ingredient : this.recipe.f_291008_().m_7527_()) {
                IngredientWrapper wrapped = new IngredientWrapper(ingredient);
                this.ingredients.add(wrapped);
            }
        }

        public RecipeHolder<?> getRecipe() {
            return this.recipe;
        }

        public ResourceLocation id() {
            return this.recipe.f_291676_();
        }

        public List<IngredientWrapper> getIngredients() {
            return this.ingredients;
        }

        public boolean conflicts(RecipeWrapper pOther) {
            if (pOther == null) {
                return false;
            }
            if (this.id().equals((Object)pOther.id())) {
                return true;
            }
            if (this.ingredients.size() != pOther.getIngredients().size()) {
                return false;
            }
            List<IngredientWrapper> otherIngredients = pOther.getIngredients();
            for (int i = 0; i < otherIngredients.size(); ++i) {
                if (otherIngredients.get(i).matches(this.getIngredients().get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class CraftingRecipeWrapper
    extends RecipeWrapper {
        private final boolean shaped;

        private CraftingRecipeWrapper(RecipeHolder<?> recipe) {
            super(recipe);
            this.shaped = Services.PLATFORM.isShaped(recipe);
        }

        public boolean isShaped() {
            return this.shaped;
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            return super.conflicts(pOther) && this.isSameShape((CraftingRecipeWrapper)pOther);
        }

        private boolean isSameShape(CraftingRecipeWrapper other) {
            if (this.shaped && other.isShaped()) {
                return Services.PLATFORM.isSameShape(this.getRecipe(), other.getRecipe());
            }
            return true;
        }
    }

    private static class SmithingRecipeWrapper
    extends RecipeWrapper {
        private SmithingRecipeWrapper(RecipeHolder<?> pRecipe) {
            super(pRecipe);
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            Object accessorSmithingRecipe;
            Ingredient template = Ingredient.f_43901_;
            Ingredient base = Ingredient.f_43901_;
            Ingredient addition = Ingredient.f_43901_;
            Ingredient otherTemplate = Ingredient.f_43901_;
            Ingredient otherBase = Ingredient.f_43901_;
            Ingredient otherAddition = Ingredient.f_43901_;
            RecipeHolder<?> recipe = this.getRecipe();
            RecipeHolder<?> otherRecipe = pOther.getRecipe();
            if (otherRecipe.f_291008_() instanceof SmithingTrimRecipe) {
                accessorSmithingRecipe = (AccessorSmithingTrimRecipe)recipe.f_291008_();
                template = accessorSmithingRecipe.getTemplate();
                base = accessorSmithingRecipe.getBase();
                addition = accessorSmithingRecipe.getAddition();
            } else if (recipe.f_291008_() instanceof SmithingTrimRecipe || recipe.f_291008_() instanceof SmithingTransformRecipe) {
                accessorSmithingRecipe = (AccessorSmithingTransformRecipe)recipe.f_291008_();
                template = accessorSmithingRecipe.getTemplate();
                base = accessorSmithingRecipe.getBase();
                addition = accessorSmithingRecipe.getAddition();
            }
            if (otherRecipe.f_291008_() instanceof SmithingTrimRecipe) {
                accessorSmithingRecipe = (AccessorSmithingTrimRecipe)otherRecipe.f_291008_();
                otherTemplate = accessorSmithingRecipe.getTemplate();
                otherBase = accessorSmithingRecipe.getBase();
                otherAddition = accessorSmithingRecipe.getAddition();
            } else if (otherRecipe.f_291008_() instanceof SmithingTransformRecipe) {
                accessorSmithingRecipe = (AccessorSmithingTransformRecipe)otherRecipe.f_291008_();
                otherTemplate = accessorSmithingRecipe.getTemplate();
                otherBase = accessorSmithingRecipe.getBase();
                otherAddition = accessorSmithingRecipe.getAddition();
            }
            IngredientWrapper baseWrapper = new IngredientWrapper(base);
            IngredientWrapper otherBaseWrapper = new IngredientWrapper(otherBase);
            IngredientWrapper additionWrapper = new IngredientWrapper(addition);
            IngredientWrapper otherAdditionWrapper = new IngredientWrapper(otherAddition);
            IngredientWrapper templateWrapper = new IngredientWrapper(template);
            IngredientWrapper otherTemplateWrapper = new IngredientWrapper(otherTemplate);
            return super.conflicts(pOther) && baseWrapper.matches(otherBaseWrapper) & additionWrapper.matches(otherAdditionWrapper) && templateWrapper.matches(otherTemplateWrapper);
        }
    }

    private static class IngredientWrapper {
        private final Ingredient ingredient;

        private IngredientWrapper(Ingredient pIngredient) {
            this.ingredient = pIngredient;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public boolean matches(IngredientWrapper pIngredient) {
            if (pIngredient == null) {
                return false;
            }
            Ingredient otherIngredient = pIngredient.getIngredient();
            if (otherIngredient == null) {
                return false;
            }
            if (otherIngredient == Ingredient.f_43901_) {
                return this.ingredient == Ingredient.f_43901_;
            }
            ItemStack[] stacks = this.ingredient.m_43908_();
            for (ItemStack otherStack : pIngredient.getIngredient().m_43908_()) {
                for (ItemStack stack : stacks) {
                    if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)otherStack)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

