/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common.capability;

import com.mojang.datafixers.util.Pair;
import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.common.capability.IPlayerRecipeData;
import com.sparky.multirecipe.client.recipe.RecipesWidget;
import com.sparky.multirecipe.common.capability.AbstractRecipeData;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PlayerRecipeData
extends AbstractRecipeData<Player>
implements IPlayerRecipeData {
    private AbstractContainerMenu containerMenu;

    public PlayerRecipeData(Player owner) {
        super(owner);
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> type, C inventory, Level level, List<RecipeHolder<T>> recipesList) {
        Optional<RecipeHolder<T>> maybeRecipe = super.getRecipe(type, inventory, level, recipesList);
        if (this.getContainerMenu() == ((Player)this.getOwner()).f_36096_) {
            this.syncPlayerRecipeData();
        }
        this.setContainerMenu(null);
        return maybeRecipe;
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        super.selectRecipe(recipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof ServerPlayer) {
            PolymorphApi.common().getPacketDistributor().sendPlayerSyncS2C((ServerPlayer)this.getOwner(), this.getRecipesList(), this.getSelectedRecipe().map(RecipeHolder::f_291676_).orElse(null));
        }
    }

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        if (this.getContainerMenu() == ((Player)this.getOwner()).f_36096_) {
            Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
            Player player = (Player)this.getOwner();
            if (player.m_9236_().m_5776_()) {
                RecipesWidget.get().ifPresent(widget -> widget.setRecipesList((Set)packetData.getFirst(), (ResourceLocation)packetData.getSecond()));
            } else if (player instanceof ServerPlayer) {
                PolymorphApi.common().getPacketDistributor().sendRecipesListS2C((ServerPlayer)player, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
            }
        }
    }

    @Override
    public Set<ServerPlayer> getListeners() {
        Player player = (Player)this.getOwner();
        if (player instanceof ServerPlayer) {
            return Collections.singleton((ServerPlayer)player);
        }
        return new HashSet<ServerPlayer>();
    }

    @Override
    public AbstractContainerMenu getContainerMenu() {
        return this.containerMenu;
    }

    @Override
    public void setContainerMenu(AbstractContainerMenu containerMenu) {
        this.containerMenu = containerMenu;
    }
}

