/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common.capability;

import com.mojang.datafixers.util.Pair;
import com.sparky.multirecipe.PolymorphConstants;
import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.common.base.IRecipePair;
import com.sparky.multirecipe.api.common.capability.IRecipeData;
import com.sparky.multirecipe.common.capability.AbstractBlockEntityRecipeData;
import com.sparky.multirecipe.common.impl.RecipePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class AbstractRecipeData<E>
implements IRecipeData<E> {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final E owner;
    private RecipeHolder<?> lastRecipe;
    private RecipeHolder<?> selectedRecipe;
    private ResourceLocation loadedRecipe;
    private boolean isFailing;
    private NonNullList<Item> input;

    public AbstractRecipeData(E owner) {
        this.owner = owner;
        this.input = NonNullList.m_122779_();
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> type, C inventory, Level level, List<RecipeHolder<T>> recipesList) {
        List recipes;
        boolean isEmpty = this.isEmpty(inventory);
        this.getLoadedRecipe().flatMap(id -> level.m_7465_().m_44043_(id)).ifPresent(selected -> {
            try {
                if (selected.f_291008_().m_6671_() == type && (selected.f_291008_().m_5818_(inventory, level) || isEmpty)) {
                    this.setSelectedRecipe((RecipeHolder<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.f_291676_(), (Object)inventory);
            }
            this.loadedRecipe = null;
        });
        if (isEmpty) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.f_291008_().m_6671_() == type && recipe.f_291008_().m_5818_(inventory, level)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.f_291008_().m_6671_() == type && selected.f_291008_().m_5818_(inventory, level)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.f_291676_(), (Object)inventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)recipe.f_291676_(), (Object)inventory);
            }
        });
        RecipeHolder result = ref.get();
        if (result != null && !(this instanceof AbstractBlockEntityRecipeData)) {
            boolean inputChanged = false;
            int size = inventory.m_6643_();
            NonNullList currentInput = NonNullList.m_122780_((int)size, (Object)Items.f_41852_);
            if (size != this.input.size()) {
                inputChanged = true;
            }
            for (int i = 0; i < size; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                Item item = stack.m_41720_();
                if (!inputChanged && i < this.input.size() && item != this.input.get(i)) {
                    inputChanged = true;
                }
                if (stack.m_41619_()) continue;
                currentInput.set(i, (Object)item);
            }
            this.input = currentInput;
            if (!inputChanged) {
                this.setFailing(false);
                this.sendRecipesListToListeners(false);
                return Optional.of(result);
            }
        }
        TreeSet<IRecipePair> newDataset = new TreeSet<IRecipePair>();
        List list = recipes = recipesList.isEmpty() ? level.m_7465_().m_44056_(type, inventory, level) : recipesList;
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        ArrayList<RecipeHolder> validRecipes = new ArrayList<RecipeHolder>();
        for (RecipeHolder entry : recipes) {
            ItemStack output;
            ResourceLocation id2 = entry.f_291676_();
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.f_291676_().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            if ((output = entry.f_291008_().m_8043_(level.m_9598_())) == null || output.m_41619_() || entry.f_291008_() instanceof CustomRecipe) {
                output = entry.f_291008_().m_5874_(inventory, level.m_9598_());
            }
            if (output.m_41619_()) continue;
            newDataset.add(new RecipePair(id2, output));
            validRecipes.add(entry);
        }
        if (validRecipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        if (result == null) {
            ResourceLocation rl = ((IRecipePair)newDataset.first()).getResourceLocation();
            for (RecipeHolder recipe2 : validRecipes) {
                if (!recipe2.f_291676_().equals((Object)rl)) continue;
                result = recipe2;
                break;
            }
        }
        if (result == null) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.lastRecipe = result;
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<? extends RecipeHolder<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(@Nonnull RecipeHolder<?> recipe) {
        this.selectedRecipe = recipe;
    }

    public Optional<? extends RecipeHolder<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<ResourceLocation> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> recipesList) {
        this.recipesList.clear();
        this.recipesList.addAll(recipesList);
    }

    @Override
    public boolean isEmpty(Container inventory) {
        if (inventory != null) {
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (inventory.m_8020_(i).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull RecipeHolder<?> recipe) {
        this.setSelectedRecipe(recipe);
    }

    @Override
    public abstract Set<ServerPlayer> getListeners();

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
        for (ServerPlayer listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean isFailing) {
        this.isFailing = isFailing;
    }

    @Override
    public void readNBT(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("SelectedRecipe")) {
            this.loadedRecipe = new ResourceLocation(compoundTag.m_128461_("SelectedRecipe"));
        }
        if (compoundTag.m_128441_("RecipeDataSet")) {
            SortedSet<IRecipePair> dataset = this.getRecipesList();
            dataset.clear();
            ListTag list = compoundTag.m_128437_("RecipeDataSet", 10);
            for (Tag inbt : list) {
                CompoundTag tag = (CompoundTag)inbt;
                ResourceLocation id = ResourceLocation.m_135820_((String)tag.m_128461_("Id"));
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ItemStack"));
                dataset.add(new RecipePair(id, stack));
            }
        }
    }

    @Override
    @Nonnull
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.getSelectedRecipe().ifPresent(selected -> nbt.m_128359_("SelectedRecipe", this.selectedRecipe.f_291676_().toString()));
        SortedSet<IRecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            ListTag list = new ListTag();
            for (IRecipePair data : dataset) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("ItemStack", (Tag)data.getOutput().m_41739_(new CompoundTag()));
                tag.m_128359_("Id", data.getResourceLocation().toString());
                list.add((Object)tag);
            }
            nbt.m_128365_("RecipeDataSet", (Tag)list);
        }
        return nbt;
    }
}

