/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common;

import com.mojang.datafixers.util.Pair;
import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.common.base.IPolymorphCommon;
import com.sparky.multirecipe.api.common.base.IPolymorphPacketDistributor;
import com.sparky.multirecipe.api.common.base.IRecipePair;
import com.sparky.multirecipe.common.util.BlockEntityTicker;
import java.util.SortedSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class PolymorphCommonEvents {
    public static void levelTick(Level level) {
        if (!level.m_5776_() && level.m_46467_() % 5L == 0L) {
            BlockEntityTicker.tick();
        }
    }

    public static void playerDisconnected(ServerPlayer serverPlayer) {
        BlockEntityTicker.remove(serverPlayer);
    }

    public static void openContainer(Player player, AbstractContainerMenu containerMenu) {
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            IPolymorphCommon commonApi = PolymorphApi.common();
            commonApi.getRecipeDataFromBlockEntity(containerMenu).ifPresent(recipeData -> {
                IPolymorphPacketDistributor packetDistributor = commonApi.getPacketDistributor();
                if (recipeData.isFailing() || recipeData.isEmpty(null)) {
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity);
                } else {
                    Pair<SortedSet<IRecipePair>, ResourceLocation> data = recipeData.getPacketData();
                    packetDistributor.sendRecipesListS2C(serverPlayerEntity, (SortedSet)data.getFirst(), (ResourceLocation)data.getSecond());
                }
            });
        }
    }
}

