/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.api.client.widget;

import com.sparky.multirecipe.api.client.base.IRecipesWidget;
import com.sparky.multirecipe.api.client.widget.OpenSelectionButton;
import com.sparky.multirecipe.api.client.widget.SelectionWidget;
import com.sparky.multirecipe.api.common.base.IRecipePair;
import com.sparky.multirecipe.platform.Services;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractRecipesWidget
implements IRecipesWidget {
    public static final ResourceLocation WIDGETS = new ResourceLocation("multirecipe", "textures/gui/widgets.png");
    protected final AbstractContainerScreen<?> containerScreen;
    protected SelectionWidget selectionWidget;
    protected OpenSelectionButton openButton;

    public AbstractRecipesWidget(AbstractContainerScreen<?> containerScreen) {
        this.containerScreen = containerScreen;
    }

    @Override
    public void initChildWidgets() {
        int x = Services.CLIENT_PLATFORM.getScreenLeft(this.containerScreen) + this.getButtonXPos();
        int y = Services.CLIENT_PLATFORM.getScreenTop(this.containerScreen) + this.getButtonYPos();
        this.selectionWidget = new SelectionWidget(x + this.getWidgetXOffset(), y + this.getWidgetYOffset(), this.getButtonXPos() + this.getWidgetXOffset(), this.getButtonYPos() + this.getWidgetYOffset(), this::selectRecipe, this.containerScreen);
        this.openButton = new OpenSelectionButton(this.containerScreen, this.getButtonXPos(), this.getButtonYPos(), clickWidget -> this.selectionWidget.setActive(!this.selectionWidget.isActive()));
        this.openButton.f_93624_ = this.selectionWidget.getOutputWidgets().size() > 1;
    }

    @Override
    public abstract void selectRecipe(ResourceLocation var1);

    @Override
    public SelectionWidget getSelectionWidget() {
        return this.selectionWidget;
    }

    @Override
    public void highlightRecipe(ResourceLocation resourceLocation) {
        this.selectionWidget.highlightButton(resourceLocation);
    }

    @Override
    public void setRecipesList(Set<IRecipePair> recipesList, ResourceLocation selected) {
        TreeSet<IRecipePair> sorted = new TreeSet<IRecipePair>(recipesList);
        this.selectionWidget.setRecipeList(sorted);
        boolean bl = this.openButton.f_93624_ = recipesList.size() > 1;
        if (selected != null) {
            this.highlightRecipe(selected);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float renderPartialTicks) {
        this.selectionWidget.m_88315_(guiGraphics, mouseX, mouseY, renderPartialTicks);
        this.openButton.m_88315_(guiGraphics, mouseX, mouseY, renderPartialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.openButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.selectionWidget.m_6375_(mouseX, mouseY, button)) {
            this.selectionWidget.setActive(false);
            return true;
        }
        if (this.selectionWidget.isActive()) {
            if (!this.openButton.m_6375_(mouseX, mouseY, button)) {
                this.selectionWidget.setActive(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getButtonXPos() {
        return this.getOutputSlot().f_40220_ + this.getButtonXOffset();
    }

    @Override
    public int getButtonYPos() {
        return this.getOutputSlot().f_40221_ + this.getButtonYOffset();
    }

    public int getButtonXOffset() {
        return 28;
    }

    public int getButtonYOffset() {
        return 28;
    }

    public int getWidgetXOffset() {
        return 25;
    }

    public int getWidgetYOffset() {
        return -3;
    }
}

