/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.packedup.BackpackItem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class BackpackUpgradeRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<BackpackUpgradeRecipe> SERIALIZER = new Serializer();
    private final String group;
    private final CraftingBookCategory category;
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final boolean showNotification;

    public BackpackUpgradeRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutput, boolean showNotification) {
        super(group, category, pattern, recipeOutput, showNotification);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = recipeOutput;
        this.showNotification = showNotification;
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            ItemStack stack = inventory.m_8020_(index);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof BackpackItem)) continue;
            ItemStack result = this.m_8043_(registryAccess).m_41777_();
            result.m_41751_(stack.m_41783_());
            if (stack.m_41788_()) {
                result.m_41714_(stack.m_41786_());
            }
            for (Map.Entry enchant : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                result.m_41663_((Enchantment)enchant.getKey(), ((Integer)enchant.getValue()).intValue());
            }
            return result;
        }
        return this.m_8043_(registryAccess).m_41777_();
    }

    private static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        private static final Codec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.group), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)ShapedRecipePattern.f_302908_.forGetter(recipe -> recipe.pattern), (App)ItemStack.f_302323_.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, BackpackUpgradeRecipe::new));

        private Serializer() {
        }

        public Codec<BackpackUpgradeRecipe> m_292673_() {
            return CODEC;
        }

        @Nullable
        public BackpackUpgradeRecipe fromNetwork(FriendlyByteBuf buffer) {
            return Serializer.fromShapedRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, BackpackUpgradeRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
        }

        private static BackpackUpgradeRecipe fromShapedRecipe(ShapedRecipe recipe) {
            return new BackpackUpgradeRecipe(recipe.m_6076_(), recipe.m_245232_(), recipe.f_302516_, recipe.m_8043_(null), recipe.m_271738_());
        }
    }
}

