/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.packedup.BackpackType;
import java.util.Locale;

public class BackpackRecipeCondition
implements ResourceCondition {
    public static final ResourceConditionSerializer<BackpackRecipeCondition> SERIALIZER = new Serializer();
    private final BackpackType type;

    public BackpackRecipeCondition(BackpackType type) {
        this.type = type;
    }

    public String toString() {
        return "backpackEnabled(" + this.type.name() + ")";
    }

    public boolean test(ResourceConditionContext context) {
        return this.type.isEnabled();
    }

    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements ResourceConditionSerializer<BackpackRecipeCondition> {
        public void serialize(JsonObject json, BackpackRecipeCondition condition) {
            json.addProperty("backpack", condition.type.name().toLowerCase(Locale.ROOT));
        }

        public BackpackRecipeCondition deserialize(JsonObject json) {
            BackpackType type = BackpackType.valueOf(json.get("backpack").getAsString().toUpperCase(Locale.ROOT));
            return new BackpackRecipeCondition(type);
        }
    }
}

