/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.PackedUpClient;
import com.supermartijn642.packedup.PackedUpCommon;
import com.supermartijn642.packedup.PackedUpConfig;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class BackpackItem
extends BaseItem {
    public BackpackType type;

    public BackpackItem(BackpackType type) {
        super(type.isEnabled() ? ItemProperties.create().maxStackSize(1).group(PackedUp.ITEM_GROUP) : ItemProperties.create().maxStackSize(1));
        this.type = type;
    }

    public BaseItem.ItemUseResult interact(ItemStack stack, Player player, InteractionHand hand, Level level) {
        if (!player.m_6047_()) {
            if (!level.f_46443_ && stack.m_41720_() instanceof BackpackItem) {
                int bagSlot = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : -1;
                PackedUpCommon.openBackpackInventory(stack, player, bagSlot);
            }
        } else if (level.f_46443_) {
            PackedUpClient.openBackpackRenameScreen(TextComponents.item((Item)stack.m_41720_()).format(), TextComponents.itemStack((ItemStack)stack).format());
        }
        return BaseItem.ItemUseResult.success((ItemStack)stack);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        CompoundTag compound;
        info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.one", (Object[])new Object[]{TextComponents.string((String)Integer.toString(this.type.getSlots())).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.AQUA).get());
        Component key = PackedUpClient.getKeyBindCharacter();
        if (key != null) {
            info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.two", (Object[])new Object[]{key}).color(ChatFormatting.AQUA).get());
        }
        if (advanced && (compound = stack.m_41784_()).m_128441_("packedup:invIndex")) {
            info.accept((Component)TextComponents.translation((String)"packedup.backpacks.info.inventory_index", (Object[])new Object[]{compound.m_128451_("packedup:invIndex")}).get());
        }
        super.appendItemInformation(stack, level, info, advanced);
    }

    public boolean isInCreativeGroup(CreativeModeTab tab) {
        return this.type.isEnabled() && super.isInCreativeGroup(tab);
    }

    public boolean m_41475_() {
        return PackedUpConfig.canBackpacksBurn.get() == false;
    }
}

