/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.google.common.collect.Lists;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.BackpackType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BackpackInventory
implements IItemHandlerModifiable {
    private final boolean remote;
    private final ArrayList<ItemStack> stacks = new ArrayList();
    private final int inventoryIndex;
    public Set<Integer> bagsInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsDirectlyInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsIn = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsDirectlyIn = new HashSet<Integer>();
    public int layer;

    public BackpackInventory(boolean remote, int inventoryIndex, int slots, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(ItemStack.f_41583_);
        }
        this.bagsInThisBag.addAll(bagsInThisBag);
        this.bagsThisBagIsIn.addAll(bagsThisBagIsIn);
        this.layer = layer;
    }

    public BackpackInventory(boolean remote, int inventoryIndex, int slots) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(ItemStack.f_41583_);
        }
    }

    public BackpackInventory(boolean remote, int inventoryIndex) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
    }

    public int getInventoryIndex() {
        return this.inventoryIndex;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack current = this.stacks.get(slot);
        if (!stack.m_41619_() && this.isItemValid(slot, stack) && BackpackInventory.canStack(current, stack)) {
            int amount = Math.min(stack.m_41613_(), 64 - current.m_41613_());
            if (!simulate) {
                int index;
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(current.m_41613_() + amount);
                this.stacks.set(slot, newStack);
                if (!this.remote && stack.m_41720_() instanceof BackpackItem && stack.m_41784_().m_128441_("packedup:invIndex") && !this.bagsDirectlyInThisBag.contains(index = stack.m_41784_().m_128451_("packedup:invIndex"))) {
                    BackpackStorageManager.onInsert(index, this.inventoryIndex);
                }
            }
            ItemStack result = stack.m_41777_();
            result.m_41774_(amount);
            return result;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.stacks.get(slot);
        int count = Math.min(amount, stack.m_41613_());
        ItemStack result = stack.m_41777_();
        if (!simulate) {
            stack.m_41774_(count);
            if (!this.remote && result.m_41720_() instanceof BackpackItem && result.m_41784_().m_128441_("packedup:invIndex")) {
                int index = result.m_41784_().m_128451_("packedup:invIndex");
                boolean contains = false;
                for (ItemStack stack1 : this.stacks) {
                    if (!(stack1.m_41720_() instanceof BackpackItem) || !stack1.m_41784_().m_128441_("packedup:invIndex") || stack1.m_41784_().m_128451_("packedup:invIndex") != index) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    BackpackStorageManager.onExtract(index, this.inventoryIndex);
                }
            }
        }
        result.m_41764_(count);
        return result;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        CompoundTag compound;
        if (stack.m_41720_() instanceof BackpackItem && !this.isBagAllowed(stack)) {
            return false;
        }
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ShulkerBoxBlock && stack.m_41782_() && (compound = stack.m_41783_().m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            NonNullList items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)items);
            for (ItemStack stack1 : items) {
                if (!(stack1.m_41720_() instanceof BackpackItem)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() || stack2.m_41619_() || stack1.m_41720_() == stack2.m_41720_() && stack1.m_41773_() == stack2.m_41773_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public void save(Path path) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("stacks", this.stacks.size());
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            compound.m_128365_("stack" + slot, (Tag)this.stacks.get(slot).m_41739_(new CompoundTag()));
        }
        compound.m_128408_("bagsInThisBag", (List)Lists.newArrayList(this.bagsInThisBag));
        compound.m_128408_("bagsThisBagIsIn", (List)Lists.newArrayList(this.bagsThisBagIsIn));
        compound.m_128405_("layer", this.layer);
        try {
            NbtIo.m_128955_((CompoundTag)compound, (Path)path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(Path path) {
        CompoundTag compound;
        try {
            compound = NbtIo.m_128953_((Path)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.stacks.clear();
        int size = compound.m_128441_("stacks") ? compound.m_128451_("stacks") : (compound.m_128441_("rows") ? compound.m_128451_("rows") * 9 : compound.m_128451_("slots"));
        for (int slot = 0; slot < size; ++slot) {
            this.stacks.add(ItemStack.m_41712_((CompoundTag)compound.m_128469_("stack" + slot)));
        }
        this.bagsInThisBag.clear();
        Arrays.stream(compound.m_128465_("bagsInThisBag")).forEach(this.bagsInThisBag::add);
        this.bagsThisBagIsIn.clear();
        Arrays.stream(compound.m_128465_("bagsThisBagIsIn")).forEach(this.bagsThisBagIsIn::add);
        this.layer = compound.m_128451_("layer");
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int index;
        ItemStack oldStack = this.stacks.get(slot);
        this.stacks.set(slot, ItemStack.f_41583_);
        if (!this.remote && oldStack.m_41720_() instanceof BackpackItem && oldStack.m_41784_().m_128441_("packedup:invIndex")) {
            index = oldStack.m_41784_().m_128451_("packedup:invIndex");
            boolean contains = false;
            for (ItemStack stack1 : this.stacks) {
                if (!(stack1.m_41720_() instanceof BackpackItem) || !stack1.m_41784_().m_128441_("packedup:invIndex") || stack1.m_41784_().m_128451_("packedup:invIndex") != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        this.stacks.set(slot, stack);
        if (!this.remote && stack.m_41720_() instanceof BackpackItem && stack.m_41784_().m_128441_("packedup:invIndex") && !this.bagsDirectlyInThisBag.contains(index = stack.m_41784_().m_128451_("packedup:invIndex"))) {
            BackpackStorageManager.onInsert(index, this.inventoryIndex);
        }
    }

    public void adjustSize(BackpackType type) {
        while (this.stacks.size() < type.getSlots()) {
            this.stacks.add(ItemStack.f_41583_);
        }
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    private boolean isBagAllowed(ItemStack bag) {
        if (BackpackStorageManager.maxLayers.get() != -1 && this.layer >= BackpackStorageManager.maxLayers.get()) {
            return false;
        }
        if (!bag.m_41784_().m_128441_("packedup:invIndex")) {
            return true;
        }
        int index = bag.m_41784_().m_128451_("packedup:invIndex");
        return index != this.inventoryIndex && !this.bagsThisBagIsIn.contains(index);
    }
}

