/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.packedup.BackpackContainer;
import com.supermartijn642.packedup.PackedUpClient;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BackpackContainerScreen
extends BaseContainerWidget<BackpackContainer> {
    private static final ResourceLocation CORNERS = new ResourceLocation("packedup", "textures/corners.png");
    private Component displayName;

    public BackpackContainerScreen() {
        super(0, 0, 0, 0);
    }

    public void initialize() {
        super.initialize();
        this.displayName = BackpackContainerScreen.trimText(((BackpackContainer)this.container).bagName, ((BackpackContainer)this.container).type.getColumns() * 18);
    }

    public Component getNarrationMessage() {
        return this.displayName;
    }

    public int width() {
        return ((BackpackContainer)this.container).type.getColumns() > 9 ? 14 + ((BackpackContainer)this.container).type.getColumns() * 18 : 176;
    }

    public int height() {
        return 112 + 18 * ((BackpackContainer)this.container).type.getRows();
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        if (((BackpackContainer)this.container).type.getColumns() == 9) {
            ScreenUtils.drawScreenBackground((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        } else {
            int backpackWidth = ((BackpackContainer)this.container).type.getColumns() * 18 + 14;
            int offset = (this.width() - backpackWidth) / 2;
            int height = ((BackpackContainer)this.container).type.getRows() * 18 + 23;
            ScreenUtils.drawScreenBackground((PoseStack)context.poseStack(), (float)offset, (float)0.0f, (float)backpackWidth, (float)height);
            ScreenUtils.drawScreenBackground((PoseStack)context.poseStack(), (float)Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 9), (float)176.0f, (float)(this.height() - height + 9));
            ScreenUtils.bindTexture((ResourceLocation)CORNERS);
            if (((BackpackContainer)this.container).type.getColumns() > 9) {
                ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 3), (float)3.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.5f, (float)0.5f);
                ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f) + 176.0f - 3.0f), (float)(height - 3), (float)3.0f, (float)3.0f, (float)0.5f, (float)0.0f, (float)0.5f, (float)0.5f);
                ScreenUtils.fillRect((PoseStack)context.poseStack(), (float)Math.max(0.0f, (float)(backpackWidth - 176) / 2.0f), (float)(height - 9), (float)176.0f, (float)6.0f, (int)-3750202);
            } else {
                ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)offset, (float)(height - 9), (float)3.0f, (float)3.0f, (float)0.0f, (float)0.5f, (float)0.5f, (float)0.5f);
                ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(offset + backpackWidth - 3), (float)(height - 9), (float)3.0f, (float)3.0f, (float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
                ScreenUtils.fillRect((PoseStack)context.poseStack(), (float)(offset + 3), (float)(height - 9), (float)(backpackWidth - 6), (float)3.0f, (int)-3750202);
            }
        }
        super.renderBackground(context, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        int offset = (((BackpackContainer)this.container).type.getColumns() - 9) * 18 / 2;
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)this.displayName, (float)(8.0f - (float)Math.min(0, offset)), (float)6.0f, (int)0x404040);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)ClientUtils.getPlayer().m_150109_().m_5446_(), (float)(8.0f + (float)Math.max(0, offset)), (float)(this.height() - 96 + 3), (int)0x404040);
        super.renderForeground(context, mouseX, mouseY);
    }

    public boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        if (!(hasBeenHandled |= super.keyPressed(keyCode, hasBeenHandled)) && PackedUpClient.OPEN_BAG_KEY.m_90832_(keyCode, -1)) {
            ((BackpackContainer)this.container).player.m_6915_();
            hasBeenHandled = true;
        }
        return hasBeenHandled;
    }

    private static Component trimText(Component textComponent, int width) {
        int length;
        String text = TextComponents.format((Component)textComponent);
        Font font = ClientUtils.getFontRenderer();
        for (length = 0; length < text.length() && font.m_92895_(text.substring(0, length + 1) + "...") < width; ++length) {
        }
        return TextComponents.string((String)(length < text.length() ? text.substring(0, length) + "..." : text)).get();
    }
}

