/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class CompassSearchPacket {
    private ResourceLocation biomeKey;
    private int x;
    private int y;
    private int z;

    public CompassSearchPacket() {
    }

    public CompassSearchPacket(ResourceLocation biomeKey, BlockPos pos) {
        this.biomeKey = biomeKey;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public CompassSearchPacket(FriendlyByteBuf buf) {
        this.biomeKey = buf.m_130281_();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.biomeKey);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static void handle(CompassSearchPacket packet, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldNatureCompass((Player)ctx.getSender());
            if (!stack.m_41619_()) {
                NaturesCompassItem natureCompass = (NaturesCompassItem)stack.m_41720_();
                natureCompass.searchForBiome(ctx.getSender().m_284548_(), (Player)ctx.getSender(), packet.biomeKey, new BlockPos(packet.x, packet.y, packet.z), stack);
            }
        });
        ctx.setPacketHandled(true);
    }
}

