/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeSearchEntry;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchList
extends ObjectSelectionList<BiomeSearchEntry> {
    private final NaturesCompassScreen parentScreen;

    public BiomeSearchList(NaturesCompassScreen parentScreen, Minecraft mc, int width, int height, int top, int bottom) {
        super(mc, width, height, top, bottom);
        this.parentScreen = parentScreen;
        this.refreshList();
    }

    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    protected boolean m_7987_(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.m_6702_().size() ? ((Object)((Object)((BiomeSearchEntry)((Object)this.m_6702_().get(slotIndex))))).equals(this.m_93511_()) : false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_239227_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_239227_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.m_5773_(); ++i) {
            int top = this.m_7610_(i);
            int bottom = this.m_93485_(i);
            if (bottom < this.m_252907_() || top > this.m_306468_()) continue;
            BiomeSearchEntry entry = (BiomeSearchEntry)this.m_93500_(i);
            if (this.m_7987_(i)) {
                int insideLeft = this.m_252754_() + this.f_93618_ / 2 - this.m_5759_() / 2 + 2;
                guiGraphics.m_280509_(insideLeft - 4, top - 4, insideLeft + this.m_5759_() + 4, top + this.f_93387_, 0x7F000000);
            }
            entry.m_6311_(guiGraphics, i, top, this.m_5747_(), this.m_5759_(), this.f_93387_ - 4, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals(this.m_93412_(mouseX, mouseY), (Object)entry), partialTicks);
        }
        if (this.m_93518_() > 0) {
            int left = this.m_5756_();
            int right = left + 6;
            int height = (int)((float)((this.m_306468_() - this.m_252907_()) * (this.m_306468_() - this.m_252907_())) / (float)this.m_5775_());
            height = Mth.m_14045_((int)height, (int)32, (int)(this.m_306468_() - this.m_252907_() - 8));
            int top = (int)this.m_93517_() * (this.m_306468_() - this.m_252907_() - height) / this.m_93518_() + this.m_252907_();
            if (top < this.m_252907_()) {
                top = this.m_252907_();
            }
            guiGraphics.m_280509_(left, this.m_252907_(), right, this.m_306468_(), 0x2B000000);
            guiGraphics.m_280509_(left, top, right, top + height, -234881024);
        }
    }

    protected int m_93485_(int itemIndex) {
        return this.m_7610_(itemIndex) + this.f_93387_;
    }

    public void refreshList() {
        this.m_93516_();
        for (Biome biome : this.parentScreen.sortBiomes()) {
            this.m_7085_((AbstractSelectionList.Entry)new BiomeSearchEntry(this, biome));
        }
        this.selectBiome(null);
    }

    public void selectBiome(BiomeSearchEntry entry) {
        this.m_6987_((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectBiome(entry);
    }

    public boolean hasSelection() {
        return this.m_93511_() != null;
    }

    public NaturesCompassScreen getParentScreen() {
        return this.parentScreen;
    }
}

