/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeInfoScreen
extends Screen {
    private NaturesCompassScreen parentScreen;
    private Biome biome;
    private Button searchButton;
    private Button backButton;
    private String source;
    private String tags;
    private String temperature;
    private String rainfall;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, Biome biome) {
        super((Component)Component.m_237115_((String)BiomeUtils.getBiomeNameForDisplay(parentScreen.level, biome)));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.source = BiomeUtils.getBiomeSource(parentScreen.level, biome);
        this.tags = BiomeUtils.getBiomeTags(parentScreen.level, biome);
        this.temperature = (double)biome.m_47554_() <= 0.5 ? I18n.m_118938_((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.m_47554_() <= 1.5 ? I18n.m_118938_((String)"string.naturescompass.medium", (Object[])new Object[0]) : I18n.m_118938_((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.getModifiedClimateSettings().f_47683_() <= 0.0f ? I18n.m_118938_((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().f_47683_() < 0.2 ? I18n.m_118938_((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().f_47683_() < 0.3 ? I18n.m_118938_((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().f_47683_() < 0.5 ? I18n.m_118938_((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.getModifiedClimateSettings().f_47683_() < 0.85 ? I18n.m_118938_((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.m_118938_((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
    }

    public void m_7856_() {
        this.setupWidgets();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), this.f_96543_ / 2 - this.f_96547_.m_92895_(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)) / 2, 20, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"string.naturescompass.source"), this.f_96543_ / 2 - 100, 40, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.source), this.f_96543_ / 2 - 100, 50, 0x808080);
        int tagsMaxWidth = this.f_96543_ / 2 - 50;
        Object tagsLine = this.tags;
        if (this.f_96547_.m_92895_((String)tagsLine) > tagsMaxWidth) {
            tagsLine = this.f_96547_.m_92834_((String)tagsLine + "...", tagsMaxWidth) + "...";
        }
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"string.naturescompass.tags"), this.f_96543_ / 2 + 40, 40, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)tagsLine), this.f_96543_ / 2 + 40, 50, 0x808080);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"string.naturescompass.rainfall"), this.f_96543_ / 2 + 40, 70, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.rainfall), this.f_96543_ / 2 + 40, 80, 0x808080);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"string.naturescompass.temperature"), this.f_96543_ / 2 - 100, 100, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.temperature), this.f_96543_ / 2 - 100, 110, 0x808080);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void setupWidgets() {
        this.m_169413_();
        this.backButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(10, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"string.naturescompass.back"), onPress -> this.f_96541_.m_91152_((Screen)this.parentScreen)));
        this.searchButton = (Button)this.m_142416_((GuiEventListener)new TransparentButton(this.f_96543_ - 120, this.f_96544_ - 30, 110, 20, (Component)Component.m_237115_((String)"string.naturescompass.search"), onPress -> this.parentScreen.searchForBiome(this.biome)));
    }
}

