/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.platform;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.catalogue.client.ForgeModData;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.platform.services.IPlatformHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModFileInfo;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public List<IModData> getAllModData() {
        return ModList.get().getMods().stream().map(ForgeModData::new).collect(Collectors.toList());
    }

    @Override
    public File getModDirectory() {
        return FMLPaths.MODSDIR.get().toFile();
    }

    @Override
    public void loadNativeImage(String modId, String resource, Consumer<NativeImage> consumer) {
        try {
            NativeImage image = null;
            IModFileInfo info = ModList.get().getModFileById(modId);
            Path path = info.getFile().findResource(new String[]{resource});
            if (Files.exists(path, new LinkOption[0])) {
                image = NativeImage.m_85058_((InputStream)Files.newInputStream(path, new OpenOption[0]));
            }
            Optional.ofNullable(image).ifPresent(consumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isCustomItemRendering(Item item) {
        return IClientItemExtensions.of((Item)item).getCustomRenderer() != Minecraft.m_91087_().m_91291_().getBlockEntityRenderer();
    }

    @Override
    public void drawUpdateIcon(GuiGraphics graphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(ForgeModData.VERSION_CHECK_ICONS, x, y, 24.0f, 0.0f, 8, 8, 64, 16);
    }
}

