/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.catalogue.Constants;
import com.mrcrayfish.catalogue.client.ClientHelper;
import com.mrcrayfish.catalogue.client.IModData;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import com.mrcrayfish.catalogue.platform.ClientServices;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class CatalogueModListScreen
extends Screen {
    private static final Comparator<ModListEntry> SORT = Comparator.comparing(o -> o.getData().getDisplayName());
    private static final ResourceLocation MISSING_BANNER = new ResourceLocation("catalogue", "textures/gui/missing_banner.png");
    private static final Map<String, Pair<ResourceLocation, Dimension>> BANNER_CACHE = new HashMap<String, Pair<ResourceLocation, Dimension>>();
    private static final Map<String, Pair<ResourceLocation, Dimension>> IMAGE_ICON_CACHE = new HashMap<String, Pair<ResourceLocation, Dimension>>();
    private static final Map<String, Item> ITEM_ICON_CACHE = new HashMap<String, Item>();
    private static final Map<String, IModData> CACHED_MODS = new HashMap<String, IModData>();
    private static ResourceLocation cachedBackground;
    private static boolean loaded;
    private final Screen parentScreen;
    private EditBox searchTextField;
    private ModList modList;
    private IModData selectedModData;
    private Button modFolderButton;
    private Button configButton;
    private Button websiteButton;
    private Button issueButton;
    private CatalogueCheckBoxButton updatesButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<? extends FormattedCharSequence> activeTooltip;

    public CatalogueModListScreen(Screen parent) {
        super(CommonComponents.f_237098_);
        this.parentScreen = parent;
        if (!loaded) {
            ClientServices.PLATFORM.getAllModData().forEach(data -> CACHED_MODS.put(data.getModId(), (IModData)data));
            loaded = true;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchTextField = new EditBox(this.f_96547_, 11, 25, 148, 20, CommonComponents.f_237098_);
        this.searchTextField.m_94151_(s -> {
            this.updateSearchField((String)s);
            this.modList.filterAndUpdateList((String)s);
            this.updateSelectedModList();
        });
        this.m_7787_((GuiEventListener)this.searchTextField);
        this.modList = new ModList();
        this.modList.m_252865_(10);
        this.modList.m_93473_(false, 0);
        this.m_7787_((GuiEventListener)this.modList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, btn -> this.f_96541_.m_91152_(null)).m_252794_(10, this.modList.m_306468_() + 8).m_253046_(127, 20).m_253136_());
        this.modFolderButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(140, this.modList.m_306468_() + 8, 0, 0, onPress -> Util.m_137581_().m_137644_(ClientServices.PLATFORM.getModDirectory())));
        int padding = 10;
        int contentLeft = this.modList.m_307439_() + 12 + padding;
        int contentWidth = this.f_96543_ - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (Component)Component.m_237115_((String)"catalogue.gui.config"), onPress -> {
            if (this.selectedModData != null) {
                this.selectedModData.openConfigScreen(this);
            }
        }));
        this.configButton.f_93624_ = false;
        this.websiteButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (Component)Component.m_237113_((String)"Website"), onPress -> this.openLink(this.selectedModData.getHomepage())));
        this.websiteButton.f_93624_ = false;
        this.issueButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (Component)Component.m_237113_((String)"Submit Bug"), onPress -> this.openLink(this.selectedModData.getIssueTracker())));
        this.issueButton.f_93624_ = false;
        this.descriptionList = new StringList(contentWidth, 50, contentLeft, 130);
        this.descriptionList.m_93473_(false, 0);
        this.descriptionList.m_93488_(false);
        this.m_7787_((GuiEventListener)this.descriptionList);
        this.updatesButton = (CatalogueCheckBoxButton)this.m_142416_((GuiEventListener)new CatalogueCheckBoxButton(this.modList.m_307439_() - 14, 7, button -> {
            this.modList.filterAndUpdateList(this.searchTextField.m_94155_());
            this.updateSelectedModList();
        }));
        this.modList.filterAndUpdateList(this.searchTextField.m_94155_());
        if (this.selectedModData != null) {
            this.setSelectedModData(this.selectedModData);
            this.updateSelectedModList();
            ModListEntry entry = this.modList.getEntryFromInfo(this.selectedModData);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.m_94155_());
    }

    private void openLink(@Nullable String url) {
        if (url != null) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            this.m_5561_(style);
        }
    }

    public void m_280273_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(graphics, mouseX, mouseY, partialTick);
        this.drawModList(graphics, mouseX, mouseY, partialTick);
        this.drawModInfo(graphics, mouseX, mouseY, partialTick);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        Optional<IModData> optional = Optional.ofNullable(CACHED_MODS.get("catalogue"));
        optional.ifPresent(this::loadAndCacheLogo);
        Pair<ResourceLocation, Dimension> pair = BANNER_CACHE.get("catalogue");
        if (pair != null && pair.getLeft() != null) {
            ResourceLocation textureId = (ResourceLocation)pair.getLeft();
            Dimension size = (Dimension)pair.getRight();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280411_(textureId, 10, 9, 10, 10, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
        }
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"catalogue.gui.info"));
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"catalogue.gui.open_mods_folder"));
        }
        if (this.activeTooltip != null) {
            graphics.m_280245_(this.f_96547_, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset);
            this.tooltipYOffset = 0;
        }
    }

    private void updateSelectedModList() {
        ModListEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModData);
        if (selectedEntry != null) {
            this.modList.m_6987_((AbstractSelectionList.Entry)selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.m_94167_(Component.m_237115_((String)"catalogue.gui.search").m_7220_((Component)Component.m_237113_((String)"...")).getString());
        } else {
            Optional<IModData> optional = CACHED_MODS.values().stream().filter(data -> data.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(IModData::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.m_94167_(displayName.substring(length));
            } else {
                this.searchTextField.m_94167_("");
            }
        }
    }

    private void drawModList(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ClientServices.PLATFORM.drawUpdateIcon(graphics, this.modList.m_307439_() - 24, 10);
        this.modList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280430_(this.f_96547_, (Component)ClientServices.COMPONENT.createTitle().m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), 70, 10, 0xFFFFFF);
        this.searchTextField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (ClientHelper.isMouseWithin(this.modList.m_307439_() - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip(ClientServices.COMPONENT.createFilterUpdates());
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int listRight = this.modList.m_307439_();
        graphics.m_280315_(listRight + 11, -1, this.f_96544_, -9408400);
        graphics.m_280509_(listRight + 12, 0, this.f_96543_, this.f_96544_, 0x66000000);
        this.descriptionList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int contentLeft = listRight + 12 + 10;
        int contentWidth = this.f_96543_ - contentLeft - 10;
        if (this.selectedModData != null) {
            String authors;
            this.drawBackground(graphics, this.f_96543_ - contentLeft + 10, listRight + 12, 0);
            this.drawBanner(graphics, contentWidth, contentLeft, 10, this.f_96543_ - (listRight + 12 + 10) - 10, 50);
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)contentLeft, 70.0f, 0.0f);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            graphics.m_280488_(this.f_96547_, this.selectedModData.getDisplayName(), 0, 0, 0xFFFFFF);
            poseStack.m_85849_();
            MutableComponent modId = Component.m_237113_((String)("Mod ID: " + this.selectedModData.getModId())).m_130940_(ChatFormatting.DARK_GRAY);
            int modIdWidth = this.f_96547_.m_92852_((FormattedText)modId);
            graphics.m_280430_(this.f_96547_, (Component)modId, contentLeft + contentWidth - modIdWidth, 92, 0xFFFFFF);
            this.drawStringWithLabel(graphics, "catalogue.gui.version", this.selectedModData.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            IModData.Update update = this.selectedModData.getUpdate();
            if (update != null && update.url() != null && !update.url().isBlank()) {
                MutableComponent version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion());
                int versionWidth = this.f_96547_.m_92852_((FormattedText)version);
                this.selectedModData.drawUpdateIcon(graphics, update, contentLeft + versionWidth + 5, 92);
                if (ClientHelper.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    MutableComponent message = ClientServices.COMPONENT.createFormatted("catalogue.gui.update_available", update.url());
                    this.setActiveTooltip((Component)message);
                }
            }
            int labelOffset = this.f_96544_ - 20;
            String license = this.selectedModData.getLicense();
            this.drawStringWithLabel(graphics, "catalogue.gui.licenses", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            labelOffset -= 15;
            String credits = this.selectedModData.getCredits();
            if (credits != null) {
                this.drawStringWithLabel(graphics, ClientServices.COMPONENT.getCreditsKey(), credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
                labelOffset -= 15;
            }
            if ((authors = this.selectedModData.getAuthors()) != null) {
                this.drawStringWithLabel(graphics, "catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            }
        } else {
            MutableComponent message = Component.m_237115_((String)"catalogue.gui.no_selection").m_130940_(ChatFormatting.GRAY);
            graphics.m_280653_(this.f_96547_, (Component)message, contentLeft + contentWidth / 2, this.f_96544_ / 2 - 5, 0xFFFFFF);
        }
    }

    private void drawStringWithLabel(GuiGraphics graphics, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, ChatFormatting labelColor, ChatFormatting contentColor) {
        MutableComponent formatted = ClientServices.COMPONENT.createFormatted(format, text);
        String rawString = formatted.getString();
        String label = rawString.substring(0, rawString.indexOf(":") + 1);
        Object content = rawString.substring(rawString.indexOf(":") + 1);
        if (this.f_96547_.m_92852_((FormattedText)formatted) > maxWidth) {
            content = this.f_96547_.m_92834_((String)content, maxWidth - this.f_96547_.m_92895_(label) - 7) + "...";
            MutableComponent credits = Component.m_237113_((String)label).m_130940_(labelColor);
            credits.m_7220_((Component)Component.m_237113_((String)content).m_130940_(contentColor));
            graphics.m_280430_(this.f_96547_, (Component)credits, x, y, 0xFFFFFF);
            if (ClientHelper.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip((Component)Component.m_237113_((String)text));
            }
        } else {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)label).m_130940_(labelColor).m_7220_((Component)Component.m_237113_((String)content).m_130940_(contentColor)), x, y, 0xFFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        IModData.Update update;
        MutableComponent version;
        int versionWidth;
        int contentLeft;
        if (ClientHelper.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (this.selectedModData != null && ClientHelper.isMouseWithin((contentLeft = this.modList.m_307439_() + 12 + 10) + (versionWidth = this.f_96547_.m_92852_((FormattedText)(version = ClientServices.COMPONENT.createVersion(this.selectedModData.getVersion())))) + 5, 92, 8, 8, (int)mouseX, (int)mouseY) && (update = this.selectedModData.getUpdate()) != null && update.url() != null && !update.url().isBlank()) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, update.url()));
            this.m_5561_(style);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void setActiveTooltip(Component content) {
        this.activeTooltip = this.f_96547_.m_92923_((FormattedText)content, Math.min(200, this.f_96543_));
        this.tooltipYOffset = 0;
    }

    private void setSelectedModData(IModData data) {
        this.selectedModData = data;
        this.loadAndCacheLogo(data);
        this.loadAndCacheBackground(data);
        this.configButton.f_93624_ = true;
        this.websiteButton.f_93624_ = true;
        this.issueButton.f_93624_ = true;
        this.configButton.f_93623_ = data.hasConfig();
        this.websiteButton.f_93623_ = data.getHomepage() != null;
        this.issueButton.f_93623_ = data.getIssueTracker() != null;
        int contentLeft = this.modList.m_307439_() + 12 + 10;
        int contentWidth = this.f_96543_ - contentLeft - 10;
        int labelCount = this.getLabelCount(data);
        this.descriptionList.m_93674_(contentWidth);
        this.descriptionList.m_293384_(this.f_96544_ - 135 - 20 - labelCount * 15);
        this.descriptionList.m_252865_(contentLeft);
        this.descriptionList.setTextFromInfo(data);
        this.descriptionList.m_93410_(0.0);
    }

    private int getLabelCount(IModData selectedModData) {
        int count = 1;
        if (selectedModData.getCredits() != null && !selectedModData.getCredits().isBlank()) {
            ++count;
        }
        if (selectedModData.getAuthors() != null && !selectedModData.getAuthors().isBlank()) {
            ++count;
        }
        return count;
    }

    private void drawBackground(GuiGraphics graphics, int contentWidth, int x, int y) {
        if (this.selectedModData == null) {
            return;
        }
        if (cachedBackground == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)cachedBackground);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, (float)x, (float)(y + 128), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, (float)(x + contentWidth), (float)(y + 128), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, (float)(x + contentWidth), (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void drawBanner(GuiGraphics graphics, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModData != null) {
            Pair<ResourceLocation, Dimension> logoInfo;
            ResourceLocation logoResource = MISSING_BANNER;
            Dimension size = new Dimension(600, 120);
            if (BANNER_CACHE.containsKey(this.selectedModData.getModId()) && (logoInfo = BANNER_CACHE.get(this.selectedModData.getModId())).getLeft() != null) {
                logoResource = (ResourceLocation)logoInfo.getLeft();
                size = (Dimension)logoInfo.getRight();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            graphics.m_280411_(logoResource, x += (contentWidth - width) / 2, y += (maxHeight - height) / 2, width, height, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
            RenderSystem.disableBlend();
        }
    }

    private void loadAndCacheLogo(IModData data) {
        if (BANNER_CACHE.containsKey(data.getModId())) {
            return;
        }
        BANNER_CACHE.put(data.getModId(), (Pair<ResourceLocation, Dimension>)Pair.of(null, (Object)new Dimension(0, 0)));
        String banner = data.getBanner();
        if (banner != null && !banner.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), banner, image -> {
                if (image.m_84982_() > 1200 || image.m_85084_() > 240) {
                    Constants.LOG.warn("Failed to load banner image for {} as it exceeds the maximum size of 1200x240px", (Object)data.getModId());
                    return;
                }
                TextureManager textureManager = this.f_96541_.m_91097_();
                BANNER_CACHE.put(data.getModId(), (Pair<ResourceLocation, Dimension>)Pair.of((Object)textureManager.m_118490_("modlogo", this.createLogoTexture((NativeImage)image, data.isLogoSmooth())), (Object)new Dimension(image.m_84982_(), image.m_85084_())));
            });
        }
    }

    private void loadAndCacheIcon(IModData data) {
        if (IMAGE_ICON_CACHE.containsKey(data.getModId())) {
            return;
        }
        IMAGE_ICON_CACHE.put(data.getModId(), (Pair<ResourceLocation, Dimension>)Pair.of(null, (Object)new Dimension(0, 0)));
        String imageIcon = data.getImageIcon();
        if (imageIcon != null && !imageIcon.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), imageIcon, image -> {
                TextureManager textureManager = this.f_96541_.m_91097_();
                IMAGE_ICON_CACHE.put(data.getModId(), (Pair<ResourceLocation, Dimension>)Pair.of((Object)textureManager.m_118490_("catalogueicon", this.createLogoTexture((NativeImage)image, false)), (Object)new Dimension(image.m_84982_(), image.m_85084_())));
            });
            return;
        }
        String logoFile = data.getBanner();
        if (logoFile != null && !logoFile.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), logoFile, image -> {
                if (image.m_84982_() == image.m_85084_()) {
                    TextureManager textureManager = this.f_96541_.m_91097_();
                    String modId = data.getModId();
                    if (BANNER_CACHE.containsKey(modId) && BANNER_CACHE.get(modId).getLeft() != null) {
                        IMAGE_ICON_CACHE.put(modId, BANNER_CACHE.get(modId));
                        return;
                    }
                    DynamicTexture texture = this.createLogoTexture((NativeImage)image, data.isLogoSmooth());
                    Dimension size = new Dimension(image.m_84982_(), image.m_85084_());
                    ResourceLocation textureId = textureManager.m_118490_("catalogueicon", texture);
                    IMAGE_ICON_CACHE.put(modId, (Pair<ResourceLocation, Dimension>)Pair.of((Object)textureId, (Object)size));
                    BANNER_CACHE.put(modId, (Pair<ResourceLocation, Dimension>)Pair.of((Object)textureId, (Object)size));
                }
            });
        }
    }

    private void loadAndCacheBackground(IModData data) {
        if (cachedBackground != null) {
            TextureManager textureManager = this.f_96541_.m_91097_();
            textureManager.m_118513_(cachedBackground);
        }
        cachedBackground = null;
        String background = data.getBackground();
        if (background != null && !background.isEmpty()) {
            ClientServices.PLATFORM.loadNativeImage(data.getModId(), background, image -> {
                if (image.m_84982_() != 512 || image.m_85084_() != 256) {
                    return;
                }
                TextureManager textureManager = this.f_96541_.m_91097_();
                cachedBackground = textureManager.m_118490_("cataloguebackground", this.createLogoTexture((NativeImage)image, false));
            });
        }
    }

    private DynamicTexture createLogoTexture(NativeImage image, final boolean smooth) {
        return new DynamicTexture(image){

            public void m_117985_() {
                this.m_117966_();
                NativeImage pixels = this.m_117991_();
                pixels.m_85013_(0, 0, 0, 0, 0, pixels.m_84982_(), pixels.m_85084_(), smooth, false, false, false);
            }
        };
    }

    static {
        loaded = false;
    }

    private class ModList
    extends ObjectSelectionList<ModListEntry> {
        public ModList() {
            super(CatalogueModListScreen.this.f_96541_, 150, CatalogueModListScreen.this.f_96544_ - 35 - 46, 46, 26);
            this.m_93488_(false);
        }

        public void m_93473_(boolean draw, int height) {
            super.m_93473_(draw, height);
        }

        protected int m_5756_() {
            return this.m_252754_() + this.f_93618_ - 6;
        }

        public int m_5747_() {
            return this.m_252754_();
        }

        public int m_5759_() {
            return this.f_93618_;
        }

        public void filterAndUpdateList(String text) {
            Predicate<IModData> filter = ClientServices.PLATFORM.isForge() || ClientServices.PLATFORM.isForge() ? data -> !CatalogueModListScreen.this.updatesButton.isSelected() || data.getUpdate() != null : data -> data.getType() == IModData.Type.DEFAULT || data.getModId().equals("minecraft") || data.getModId().equals("fabric-api") || CatalogueModListScreen.this.updatesButton.isSelected();
            List entries = CACHED_MODS.values().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(filter).map(info -> new ModListEntry((IModData)info, this)).sorted(SORT).collect(Collectors.toList());
            this.m_5988_(entries);
            this.m_93410_(0.0);
        }

        @Nullable
        public ModListEntry getEntryFromInfo(IModData data) {
            return this.m_6702_().stream().filter(entry -> entry.data == data).findFirst().orElse(null);
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.m_280246_(0.125f, 0.125f, 0.125f, 1.0f);
            graphics.m_280163_(Screen.f_279548_, this.m_252754_(), this.m_252907_(), (float)this.m_307439_(), (float)(this.m_306468_() + (int)this.m_93517_()), this.f_93618_, this.f_93619_, 32, 32);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        }

        public boolean m_7933_(int key, int scanCode, int modifiers) {
            if (key == 257 && this.m_93511_() != null) {
                CatalogueModListScreen.this.setSelectedModData(((ModListEntry)this.m_93511_()).data);
                SoundManager handler = Minecraft.m_91087_().m_91106_();
                handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return super.m_7933_(key, scanCode, modifiers);
        }

        public void centerScrollOn(ModListEntry entry) {
            super.m_93494_((AbstractSelectionList.Entry)entry);
        }
    }

    private class StringList
    extends AbstractSelectionList<StringEntry> {
        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.f_96541_, width, height, top, 10);
            this.m_252865_(left);
            this.m_253211_(top);
        }

        public void setTextFromInfo(IModData data) {
            this.m_93516_();
            CatalogueModListScreen.this.f_96547_.m_92865_().m_92432_(data.getDescription().trim(), this.m_5759_(), Style.f_131099_).forEach(text -> this.m_7085_((AbstractSelectionList.Entry)new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void m_93473_(boolean draw, int height) {
            super.m_93473_(draw, height);
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int m_5756_() {
            return this.m_252754_() + this.f_93618_ - 7;
        }

        public int m_5747_() {
            return this.m_252754_();
        }

        public int m_5759_() {
            return this.f_93618_ - 10;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_307439_(), this.m_306468_());
            super.m_87963_(graphics, mouseX, mouseY, partialTicks);
            graphics.m_280618_();
        }

        protected void m_168797_(NarrationElementOutput output) {
        }
    }

    private class ModListEntry
    extends ObjectSelectionList.Entry<ModListEntry> {
        private final IModData data;
        private final ModList list;
        private ItemStack icon;

        public ModListEntry(IModData data, ModList list) {
            this.data = data;
            this.list = list;
            this.icon = new ItemStack((ItemLike)this.getItemIcon());
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.m_280430_(CatalogueModListScreen.this.f_96547_, this.getFormattedModName(), left + 24, top + 2, 0xFFFFFF);
            graphics.m_280430_(CatalogueModListScreen.this.f_96547_, (Component)Component.m_237113_((String)this.data.getVersion().toString()).m_130940_(ChatFormatting.GRAY), left + 24, top + 12, 0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.data);
            if (IMAGE_ICON_CACHE.containsKey(this.data.getModId()) && IMAGE_ICON_CACHE.get(this.data.getModId()).getLeft() != null) {
                ResourceLocation logoResource = TextureManager.f_118466_;
                Dimension size = new Dimension(16, 16);
                Pair<ResourceLocation, Dimension> logoInfo = IMAGE_ICON_CACHE.get(this.data.getModId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (ResourceLocation)logoInfo.getLeft();
                    size = (Dimension)logoInfo.getRight();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                graphics.m_280411_(logoResource, left + 4, top + 2, 16, 16, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
                RenderSystem.disableBlend();
            } else {
                try {
                    graphics.m_280203_(this.icon, left + 4, top + 2);
                }
                catch (Exception e) {
                    Constants.LOG.debug("Failed to draw icon for mod '{}'", (Object)this.data.getModId());
                    ITEM_ICON_CACHE.put(this.data.getModId(), Items.f_42276_);
                    this.icon = new ItemStack((ItemLike)Items.f_42276_);
                }
            }
            IModData.Update update = this.data.getUpdate();
            if (update != null) {
                this.data.drawUpdateIcon(graphics, update, left + rowWidth - 8 - 10, top + 6);
            }
        }

        private Item getItemIcon() {
            Item item2;
            ResourceLocation resource;
            if (ITEM_ICON_CACHE.containsKey(this.data.getModId())) {
                return ITEM_ICON_CACHE.get(this.data.getModId());
            }
            ITEM_ICON_CACHE.put(this.data.getModId(), Items.f_42276_);
            if (this.data.getModId().equals("forge")) {
                Item item3 = Items.f_42146_;
                ITEM_ICON_CACHE.put("forge", item3);
                return item3;
            }
            String itemIcon = this.data.getItemIcon();
            if (itemIcon != null && !itemIcon.isEmpty() && (resource = ResourceLocation.m_135820_((String)itemIcon)) != null && (item2 = (Item)BuiltInRegistries.f_257033_.m_7745_(resource)) != null && item2 != Items.f_41852_) {
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            Optional<Item> optional = BuiltInRegistries.f_257033_.m_123024_().filter(item -> item.m_204114_().m_205785_().m_135782_().m_135827_().equals(this.data.getModId())).findFirst();
            if (optional.isPresent() && (item2 = optional.get()) != Items.f_41852_) {
                if (ClientServices.PLATFORM.isCustomItemRendering(item2)) {
                    ITEM_ICON_CACHE.put(this.data.getModId(), Items.f_42276_);
                    return Items.f_42276_;
                }
                ITEM_ICON_CACHE.put(this.data.getModId(), item2);
                return item2;
            }
            return Items.f_42276_;
        }

        private Component getFormattedModName() {
            Object name = this.data.getDisplayName();
            int width = this.list.m_5759_() - (this.list.m_93518_() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.f_96547_.m_92895_((String)name) > width) {
                name = CatalogueModListScreen.this.f_96547_.m_92834_((String)name, width - 10) + "...";
            }
            MutableComponent title = Component.m_237113_((String)name);
            if (this.data.isInternal()) {
                title.m_130940_(ChatFormatting.DARK_GRAY);
            }
            return title;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            CatalogueModListScreen.this.setSelectedModData(this.data);
            this.list.m_6987_((AbstractSelectionList.Entry)this);
            return false;
        }

        public IModData getData() {
            return this.data;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.data.getDisplayName());
        }
    }

    private record Dimension(int width, int height) {
    }

    private class StringEntry
    extends ObjectSelectionList.Entry<StringEntry> {
        private final String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.m_280488_(CatalogueModListScreen.this.f_96547_, this.line, left, top, 0xFFFFFF);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.line);
        }
    }
}

