/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.tipsmod.api.TipTypes;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.Constants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class TipManager
extends SimpleJsonResourceReloadListener {
    private final Map<ResourceLocation, TipHolder> loadedTips = new HashMap<ResourceLocation, TipHolder>();
    private final List<TipHolder> randomAccess = new ArrayList<TipHolder>();
    private final List<TipHolder> immutableAccess = Collections.unmodifiableList(this.randomAccess);

    public TipManager() {
        super(new Gson(), "tips");
    }

    public List<TipHolder> getTips() {
        return this.immutableAccess;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.loadedTips.clear();
        this.randomAccess.clear();
        long startTime = System.nanoTime();
        map.forEach((tipId, tipData) -> {
            try {
                ITip tipEntry = (ITip)((Pair)TipTypes.TIP_DISPATCH.decode((DynamicOps)JsonOps.INSTANCE, tipData).getOrThrow(false, error -> Constants.LOG.error("Could not decode tip {}. Error: {}", tipId, error))).getFirst();
                if (tipEntry != null) {
                    TipHolder holder = new TipHolder((ResourceLocation)tipId, tipEntry);
                    this.loadedTips.put((ResourceLocation)tipId, holder);
                    this.randomAccess.add(holder);
                } else {
                    Constants.LOG.error("Tip {} was null and will not be loaded. Data: {}", tipId, tipData);
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load tip {}!", tipId, (Object)e);
            }
        });
        Constants.LOG.info("Loaded {} tips. Took {}ms.", (Object)this.loadedTips.size(), (Object)((double)(System.nanoTime() - startTime) / 1000000.0));
        Constants.LOG.info("The following screens have been registered to the tips mod.");
        TipsAPI.getTipsScreens().forEach(screen -> Constants.LOG.info("Screen: '{}' Enabled: '{}'", (Object)screen.getCanonicalName(), (Object)TipsAPI.canRenderOnScreen(screen)));
    }

    public record TipHolder(ResourceLocation id, ITip tip) {
    }
}

