/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.resources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.tipsmod.api.TipTypes;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.minecraft.network.chat.Component;

public class SimpleTip
implements ITip {
    public static final CodecHelper<SimpleTip> CODEC = new CodecHelper(RecordCodecBuilder.create(instance -> instance.group((App)BookshelfCodecs.TEXT.get("title", SimpleTip::getTitle, (Object)TipsAPI.DEFAULT_TITLE), (App)BookshelfCodecs.TEXT.get("tip", SimpleTip::getText), (App)BookshelfCodecs.INT.getOptional("cycleTime", SimpleTip::getInternalCycleTime)).apply((Applicative)instance, SimpleTip::new)), (Object[])new SimpleTip[0]);
    public static final ByteBufHelper<SimpleTip> BUFFER = new ByteBufHelper(buffer -> {
        Component title = (Component)BookshelfByteBufs.TEXT.read(buffer);
        Component tip = (Component)BookshelfByteBufs.TEXT.read(buffer);
        Optional cycleTime = BookshelfByteBufs.INT.readOptional(buffer);
        return new SimpleTip(title, tip, cycleTime);
    }, (buffer, toWrite) -> {
        BookshelfByteBufs.TEXT.write(buffer, (Object)toWrite.getTitle());
        BookshelfByteBufs.TEXT.write(buffer, (Object)toWrite.getText());
        BookshelfByteBufs.INT.writeOptional(buffer, toWrite.getInternalCycleTime());
    }, (Object[])new SimpleTip[0]);
    private final Component title;
    private final Component text;
    private final Optional<Integer> cycleTime;

    public SimpleTip(Component title, Component text, Optional<Integer> cycleTime) {
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Component getText() {
        return this.text;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime.orElse(TipsModCommon.CONFIG.defaultCycleTime);
    }

    @Override
    public TipTypes.TipType getType() {
        return TipTypes.SIMPLE_TIP_TYPE;
    }

    protected Optional<Integer> getInternalCycleTime() {
        return this.cycleTime;
    }
}

