/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.Constants;
import net.darkhax.tipsmod.impl.TipsModCommon;
import net.darkhax.tipsmod.impl.resources.SimpleTip;
import net.darkhax.tipsmod.impl.resources.TipManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class TipsAPI {
    public static final ResourceLocation DEFAULT_SERIALIZER = Constants.id((String)"simple_tip");
    public static final Component DEFAULT_TITLE = Component.m_237115_((String)"tipsmod.title.default").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE, ChatFormatting.YELLOW});
    public static final TipManager.TipHolder EMPTY = new TipManager.TipHolder(Constants.id((String)"empty"), new SimpleTip(DEFAULT_TITLE, (Component)Component.m_237113_((String)"No tips loaded. Please review your config options!"), Optional.of(999999)));
    private static Set<Class<? extends Screen>> SCREENS = new HashSet<Class<? extends Screen>>();

    public static void registerTipScreen(Class<? extends Screen> screenClass) {
        SCREENS.add(screenClass);
    }

    public static boolean canRenderOnScreen(Screen screen) {
        return TipsAPI.canRenderOnScreen(screen.getClass());
    }

    public static boolean canRenderOnScreen(Class<?> clazz) {
        return SCREENS.contains(clazz) && !TipsModCommon.CONFIG.ignoredScreens.contains(clazz.getCanonicalName());
    }

    public static Collection<Class<?>> getTipsScreens() {
        return Collections.unmodifiableSet(SCREENS);
    }

    public static TipManager.TipHolder getRandomTip() {
        List<TipManager.TipHolder> filteredTips = TipsAPI.getLoadedTips().stream().filter(TipsAPI::canDisplayTip).toList();
        if (!filteredTips.isEmpty()) {
            return filteredTips.get(Constants.RANDOM.nextInt(filteredTips.size()));
        }
        return EMPTY;
    }

    public static List<TipManager.TipHolder> getLoadedTips() {
        return TipsModCommon.TIP_MANAGER.getTips();
    }

    public static boolean canDisplayTip(TipManager.TipHolder holder) {
        TranslatableContents translatableContents;
        String key;
        if (holder == null || holder.tip() == null) {
            return false;
        }
        ResourceLocation id = holder.id();
        if (TipsModCommon.CONFIG.ignoredNamespaces.contains(id.m_135827_())) {
            return false;
        }
        if (TipsModCommon.CONFIG.ignoredTips.contains(id.toString())) {
            return false;
        }
        ComponentContents contents = holder.tip().getText().m_214077_();
        return !(contents instanceof TranslatableContents) || I18n.m_118936_((String)(key = (translatableContents = (TranslatableContents)contents).m_237508_()));
    }
}

