/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.api;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.Constants;
import net.darkhax.tipsmod.impl.resources.SimpleTip;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TipTypes {
    private static final Map<ResourceLocation, TipType<? extends ITip>> TIP_TYPES = new HashMap<ResourceLocation, TipType<? extends ITip>>();
    public static final CodecHelper<TipType<? extends ITip>> TIP_TYPE_CODEC = new CodecHelper(ResourceLocation.f_135803_.xmap(id -> TIP_TYPES.containsKey(id) ? TIP_TYPES.get(id) : TIP_TYPES.get(TipsAPI.DEFAULT_SERIALIZER), TipType::id), (Object[])new TipType[0]);
    public static final ByteBufHelper<TipType<?>> TIP_TYPE_BUFFER = new ByteBufHelper(TipType::readFromBuffer, TipType::writeToBuffer, (Object[])new TipType[0]);
    public static final Codec<ITip> TIP_DISPATCH = BookshelfCodecs.dispatchFallback((Codec)TIP_TYPE_CODEC.get(), ITip::getType, tipType -> tipType.getCodec(), () -> TipTypes.TIP_TYPES.get((Object)TipsAPI.DEFAULT_SERIALIZER).codec.get());
    public static final CodecHelper<ITip> DISPLAY_STATE_CODEC = new CodecHelper(TIP_DISPATCH, (Object[])new ITip[0]);
    public static final ByteBufHelper<ITip> DISPLAY_STATE_BUFFER = new ByteBufHelper(TipTypes::readFromBuffer, TipTypes::writeToBuffer, (Object[])new ITip[0]);
    public static final TipType<SimpleTip> SIMPLE_TIP_TYPE = TipTypes.register(TipsAPI.DEFAULT_SERIALIZER, SimpleTip.CODEC, SimpleTip.BUFFER);

    public static <T extends ITip> TipType<T> register(ResourceLocation id, CodecHelper<T> codec, ByteBufHelper<T> buffer) {
        TipType<T> type = new TipType<T>(id, codec, buffer);
        if (TIP_TYPES.containsKey(id)) {
            Constants.LOG.warn("Display type ID {} has already been assigned to {}. Replacing with {}.", new Object[]{id, TIP_TYPES.get(id), type});
        }
        TIP_TYPES.put(id, type);
        return type;
    }

    private static ITip readFromBuffer(FriendlyByteBuf buffer) {
        TipType type = (TipType)TIP_TYPE_BUFFER.read(buffer);
        return (ITip)type.buffer.read(buffer);
    }

    private static void writeToBuffer(FriendlyByteBuf buffer, ITip toWrite) {
        TIP_TYPE_BUFFER.write(buffer, (Object)toWrite.getType());
        toWrite.getType().buffer.write(buffer, (Object)toWrite);
    }

    public record TipType<T extends ITip>(ResourceLocation id, CodecHelper<T> codec, ByteBufHelper<T> buffer) {
        @Override
        public String toString() {
            return "TipType{id=" + this.id + ", codec=" + this.codec + ", buffer=" + this.buffer + "}";
        }

        public Codec<T> getCodec() {
            return this.codec.get();
        }

        private static TipType<?> readFromBuffer(FriendlyByteBuf buffer) {
            ResourceLocation id = (ResourceLocation)BookshelfByteBufs.RESOURCE_LOCATION.read(buffer);
            return TIP_TYPES.get(id);
        }

        private static void writeToBuffer(FriendlyByteBuf buffer, TipType<?> toWrite) {
            BookshelfByteBufs.RESOURCE_LOCATION.write(buffer, (Object)toWrite.id);
        }
    }
}

