/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ServerboundSorterPacket {
    private final byte screenID;
    private final byte button;
    private final boolean shiftPressed;

    public ServerboundSorterPacket(byte screenID, byte button, boolean shiftPressed) {
        this.screenID = screenID;
        this.button = button;
        this.shiftPressed = shiftPressed;
    }

    public static ServerboundSorterPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        byte button = buffer.readByte();
        boolean shiftPressed = buffer.readBoolean();
        return new ServerboundSorterPacket(screenID, button, shiftPressed);
    }

    public static void encode(ServerboundSorterPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.button);
        buffer.writeBoolean(message.shiftPressed);
    }

    public static void handle(ServerboundSorterPacket message, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayerEntity = ctx.getSender();
            if (serverPlayerEntity != null) {
                ServerActions.sortBackpack((Player)serverPlayerEntity, message.screenID, message.button, message.shiftPressed);
            }
        });
        ctx.setPacketHandled(true);
    }
}

