/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingContainerImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.PacketDistributor;

public class TravelersBackpackBaseMenu
extends AbstractContainerMenu {
    public Inventory inventory;
    public ITravelersBackpackContainer container;
    public CraftingContainerImproved craftSlots;
    public ResultContainer resultSlots = new ResultContainer();
    private final int BACKPACK_INV_START = 1;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;
    private final int CRAFTING_GRID_START;
    private final int CRAFTING_GRID_END;

    public TravelersBackpackBaseMenu(MenuType<?> type, int windowID, Inventory inventory, ITravelersBackpackContainer container) {
        super(type, windowID);
        this.inventory = inventory;
        this.container = container;
        this.craftSlots = new CraftingContainerImproved(container, this);
        this.BACKPACK_INV_END = 1 + container.getHandler().getSlots() - 1;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + container.getToolSlotsHandler().getSlots() - 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.BUCKET_LEFT_OUT + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_RIGHT_IN + 1;
        this.CRAFTING_GRID_START = this.BUCKET_RIGHT_OUT + 1;
        this.CRAFTING_GRID_END = this.CRAFTING_GRID_START + 8;
        this.PLAYER_INV_START = this.CRAFTING_GRID_END + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addBackpackInventory(container);
        this.addToolSlots(container);
        this.addFluidSlots(container);
        this.addCraftingSlots();
        this.addPlayerInventoryAndHotbar(inventory, inventory.f_35977_);
    }

    public void addCraftResult() {
        this.m_38897_((Slot)new ResultSlotExt(this.container, this.inventory.f_35978_, this.craftSlots, this.resultSlots, 0, 270, 113));
    }

    public void addBackpackInventory(ITravelersBackpackContainer container) {
        int slot = 0;
        for (int i = 0; i < container.getRows(); ++i) {
            int lastRowSlots = container.getHandler().getSlots() % 9;
            if (lastRowSlots == 0) {
                lastRowSlots = 9;
            }
            int slotsInRow = i == container.getRows() - 1 ? lastRowSlots : 9;
            for (int j = 0; j < slotsInRow; ++j) {
                this.m_38897_((Slot)new BackpackSlotItemHandler((IItemHandler)container.getHandler(), slot++, 44 + j * 18, 7 + i * 18));
            }
        }
    }

    public void addFluidSlots(ITravelersBackpackContainer container) {
        this.m_38897_((Slot)new FluidSlotItemHandler(container, 0, 6, 7){

            @Override
            public boolean m_6659_() {
                return !TravelersBackpackBaseMenu.this.container.getSettingsManager().showToolSlots() && super.m_6659_();
            }
        });
        this.m_38897_((Slot)new FluidSlotItemHandler(container, 1, 6, 37){

            @Override
            public boolean m_6659_() {
                return !TravelersBackpackBaseMenu.this.container.getSettingsManager().showToolSlots() && super.m_6659_();
            }
        });
        this.m_38897_((Slot)new FluidSlotItemHandler(container, 2, 226, 7));
        this.m_38897_((Slot)new FluidSlotItemHandler(container, 3, 226, 37));
    }

    public void addToolSlots(ITravelersBackpackContainer container) {
        for (int i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
            this.m_38897_((Slot)new ToolSlotItemHandler(this.inventory.f_35978_, container, i, 6, 7 + 18 * i));
        }
    }

    public void addCraftingSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftSlots, j + i * 3, 252 + j * 18, 47 + i * 18){

                    public boolean m_6659_() {
                        return TravelersBackpackBaseMenu.this.container.getSettingsManager().showCraftingGrid();
                    }
                });
            }
        }
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 44 + x * 18, 71 + this.container.getYOffset() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 44 + x * 18, 129 + this.container.getYOffset()));
        }
    }

    protected void canCraft(Level level, Player player) {
        if (this.container.getSettingsManager().hasCraftingGrid()) {
            this.slotChangedCraftingGrid(level, player);
        }
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        this.canCraft(this.inventory.f_35978_.m_9236_(), this.inventory.f_35978_);
    }

    public void m_150429_() {
        super.m_150429_();
        this.m_6199_((Container)new RecipeWrapper((IItemHandlerModifiable)this.container.getCraftingGridHandler()));
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultSlots && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = this.m_38853_(index);
        ItemStack result = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            result = stack.m_41777_();
            if (index >= 0 && index <= this.CRAFTING_GRID_END) {
                if (index == 0) {
                    return this.handleShiftCraft(player, slot);
                }
                if (!this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return ItemStack.f_41583_;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
                    Pair<Integer, ItemStack> pair;
                    Iterator<Pair<Integer, ItemStack>> iterator = this.container.getSlotManager().getMemorySlots().iterator();
                    while (!(!iterator.hasNext() || ItemStackUtils.isSameItemSameTags((ItemStack)(pair = iterator.next()).getSecond(), stack) && this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41613_() != this.m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41741_() && this.m_38903_(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false))) {
                    }
                }
                if (ToolSlotItemHandler.isValid(stack) && !this.m_38903_(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.m_38903_(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return result;
    }

    public ItemStack handleShiftCraft(Player player, Slot resultSlot) {
        ItemStack outputCopy = ItemStack.f_41583_;
        if (resultSlot != null && resultSlot.m_6657_()) {
            this.craftSlots.checkChanges = false;
            RecipeHolder recipe = this.resultSlots.m_40158_();
            while (recipe != null && ((CraftingRecipe)recipe.f_291008_()).m_5818_((Container)this.craftSlots, player.m_9236_())) {
                ItemStack recipeOutput = resultSlot.m_7993_().m_41777_();
                outputCopy = recipeOutput.m_41777_();
                recipeOutput.m_41720_().m_7836_(recipeOutput, player.m_9236_(), player);
                if (!player.m_9236_().f_46443_) {
                    if (this.container.getSettingsManager().shiftClickToBackpack()) {
                        if (!this.m_38903_(recipeOutput, 1, this.BACKPACK_INV_END + 1, false)) {
                            this.craftSlots.checkChanges = true;
                            return ItemStack.f_41583_;
                        }
                    } else if (!this.m_38903_(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                        this.craftSlots.checkChanges = true;
                        return ItemStack.f_41583_;
                    }
                }
                resultSlot.m_40234_(recipeOutput, outputCopy);
                resultSlot.m_6654_();
                if (!player.m_9236_().f_46443_ && recipeOutput.m_41613_() == outputCopy.m_41613_()) {
                    this.craftSlots.checkChanges = true;
                    return ItemStack.f_41583_;
                }
                this.resultSlots.m_40156_(recipe);
                resultSlot.m_142406_(player, recipeOutput);
            }
            this.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(player.m_9236_(), player);
            this.container.setDataChanged(2);
        }
        this.craftSlots.checkChanges = true;
        return this.resultSlots.m_40158_() == null ? ItemStack.f_41583_ : outputCopy;
    }

    public void slotChangedCraftingGrid(Level level, Player player) {
        if (!level.f_46443_ && this.craftSlots.checkChanges) {
            ItemStack itemstack = ItemStack.f_41583_;
            RecipeHolder oldRecipe = this.resultSlots.m_40158_();
            RecipeHolder recipe = oldRecipe;
            if (recipe == null || !((CraftingRecipe)recipe.f_291008_()).m_5818_((Container)this.craftSlots, level)) {
                recipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftSlots, level).orElse(null);
            }
            if (recipe != null) {
                itemstack = ((CraftingRecipe)recipe.f_291008_()).m_5874_((Container)this.craftSlots, level.m_9598_());
            }
            if (oldRecipe != recipe) {
                TravelersBackpack.NETWORK.send((Object)new ClientboundUpdateRecipePacket(recipe, itemstack), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
                this.resultSlots.m_6836_(0, itemstack);
                this.resultSlots.m_40156_(recipe);
            } else if (recipe != null && (((CraftingRecipe)recipe.f_291008_()).m_5598_() || !recipe.getClass().getName().startsWith("net.minecraft") && !ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)this.resultSlots.m_8020_(0)))) {
                TravelersBackpack.NETWORK.send((Object)new ClientboundUpdateRecipePacket(recipe, itemstack), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
                this.resultSlots.m_6836_(0, itemstack);
                this.resultSlots.m_40156_(recipe);
            }
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
            return;
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public void m_6877_(Player player) {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(11);
        }
        if (this.container.getScreenID() == 3) {
            if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
                this.container.getSlotManager().setChanged();
            }
            this.container.setUsingPlayer(null);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)0)) {
            this.container.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.clearSlotsAndPlaySound(player, this.container.getFluidSlotsHandler(), 4);
        this.shiftTools(this.container);
        if (!TravelersBackpackConfig.craftingSavesItems) {
            this.clearSlotsAndPlaySound(player, this.container.getCraftingGridHandler(), 9);
        } else {
            this.checkCraftingGridAndPlaySound(player);
        }
        super.m_6877_(player);
    }

    public void clearSlotsAndPlaySound(Player player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, handler, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(Player player, ItemStackHandler handler, int index) {
        if (!handler.getStackInSlot(index).m_41619_()) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
                ItemStack stack = handler.getStackInSlot(index).m_41777_();
                handler.setStackInSlot(index, ItemStack.f_41583_);
                player.m_36176_(stack, false);
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.f_41583_);
            player.m_150109_().m_150079_(stack);
            return true;
        }
        return false;
    }

    public void playSound(Player player) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, (1.0f + (player.m_9236_().m_213780_().m_188501_() - player.m_9236_().m_213780_().m_188501_()) * 0.2f) * 0.7f);
    }

    public void shiftTools(ITravelersBackpackContainer container) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
            if (foundEmptySlot && !container.getToolSlotsHandler().getStackInSlot(i).m_41619_()) {
                needsShifting = true;
            }
            if (!container.getToolSlotsHandler().getStackInSlot(i).m_41619_() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            NonNullList tools = NonNullList.m_122780_((int)container.getToolSlotsHandler().getSlots(), (Object)ItemStack.f_41583_);
            int j = 0;
            for (i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
                if (container.getToolSlotsHandler().getStackInSlot(i).m_41619_()) continue;
                tools.set(j, (Object)container.getToolSlotsHandler().getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
                if (tools.isEmpty()) continue;
                container.getToolSlotsHandler().setStackInSlot(i, (ItemStack)tools.get(j));
                ++j;
            }
        }
    }

    public void checkCraftingGridAndPlaySound(Player player) {
        boolean playSound = false;
        for (int i = 0; i < this.container.getCraftingGridHandler().getSlots(); ++i) {
            boolean flag = this.clearCraftingGridSlot(player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearCraftingGridSlot(Player player, int index) {
        if (!BackpackSlotItemHandler.isItemValid(this.container.getCraftingGridHandler().getStackInSlot(index))) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
                ItemStack stack = this.container.getCraftingGridHandler().getStackInSlot(index).m_41777_();
                this.container.getCraftingGridHandler().setStackInSlot(index, ItemStack.f_41583_);
                player.m_36176_(stack, false);
                return false;
            }
            ItemStack stack = this.container.getCraftingGridHandler().getStackInSlot(index);
            this.container.getCraftingGridHandler().setStackInSlot(index, ItemStack.f_41583_);
            player.m_150109_().m_150079_(stack);
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

