/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class ShapedBackpackRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public ShapedBackpackRecipeBuilder(RecipeCategory pCategory, ItemLike pResult, int pCount) {
        this.category = pCategory;
        this.result = pResult.m_5456_();
        this.count = pCount;
    }

    public static ShapedBackpackRecipeBuilder shaped(RecipeCategory pCategory, ItemLike pResult) {
        return ShapedBackpackRecipeBuilder.shaped(pCategory, pResult, 1);
    }

    public static ShapedBackpackRecipeBuilder shaped(RecipeCategory pCategory, ItemLike pResult, int pCount) {
        return new ShapedBackpackRecipeBuilder(pCategory, pResult, pCount);
    }

    public ShapedBackpackRecipeBuilder define(Character pSymbol, TagKey<Item> pTag) {
        return this.define(pSymbol, Ingredient.m_204132_(pTag));
    }

    public ShapedBackpackRecipeBuilder define(Character pSymbol, ItemLike pItem) {
        return this.define(pSymbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{pItem}));
    }

    public ShapedBackpackRecipeBuilder define(Character pSymbol, Ingredient pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public ShapedBackpackRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ShapedBackpackRecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public ShapedBackpackRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedBackpackRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        ShapedRecipePattern shapedrecipepattern = this.ensureValid(pId);
        Advancement.Builder advancement$builder = pRecipeOutput.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)pId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pId)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).m_138383_(arg_0, arg_1));
        ShapedBackpackRecipe shapedBackpackRecipe = new ShapedBackpackRecipe(Objects.requireNonNullElse(this.group, ""), RecipeBuilder.m_307035_((RecipeCategory)this.category), shapedrecipepattern, new ItemStack((ItemLike)this.result, this.count), this.showNotification);
        pRecipeOutput.m_292927_(pId, (Recipe)shapedBackpackRecipe, advancement$builder.m_138403_(pId.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private ShapedRecipePattern ensureValid(ResourceLocation p_126144_) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
        return ShapedRecipePattern.m_306906_(this.key, this.rows);
    }
}

