/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(String groupIn, CraftingBookCategory category, ShapedRecipePattern shapedRecipePattern, ItemStack recipeOutputIn, boolean pShowNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, pShowNotification);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess access) {
        ItemStack output = super.m_5874_(inv, access);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (!ingredient.m_41619_() && ingredient.m_41720_() instanceof TravelersBackpackItem) {
                    CompoundTag compound = ingredient.m_41783_();
                    output.m_41751_(compound);
                    break;
                }
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof SleepingBagItem)) continue;
                output.m_41784_().m_128405_("SleepingBagColor", ShapedBackpackRecipe.getProperColor((SleepingBagItem)ingredient.m_41720_()));
            }
        }
        return output;
    }

    public static int getProperColor(SleepingBagItem item) {
        Block block = item.m_40614_();
        if (block instanceof SleepingBagBlock) {
            SleepingBagBlock sleepingBag = (SleepingBagBlock)block;
            return sleepingBag.m_49554_().m_41060_();
        }
        return DyeColor.RED.m_41060_();
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final Codec<ShapedBackpackRecipe> CODEC = RecordCodecBuilder.create(p_309256_ -> p_309256_.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_309251_ -> p_309251_.m_6076_()), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_309253_ -> p_309253_.m_245232_()), (App)ShapedRecipePattern.f_302908_.forGetter(p_309254_ -> p_309254_.f_302516_), (App)ItemStack.f_302323_.fieldOf("result").forGetter(p_309252_ -> p_309252_.f_44149_), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_309255_ -> p_309255_.m_271738_())).apply((Applicative)p_309256_, ShapedBackpackRecipe::new));

        public Codec<ShapedBackpackRecipe> m_292673_() {
            return CODEC;
        }

        @Nullable
        public ShapedBackpackRecipe fromNetwork(FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.m_306640_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            boolean flag = buffer.readBoolean();
            return new ShapedBackpackRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedBackpackRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            recipe.f_302516_.m_307574_(buffer);
            buffer.m_130055_(recipe.f_44149_);
            buffer.writeBoolean(recipe.m_271738_());
        }
    }
}

