/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackTooltipComponent
implements TooltipComponent {
    protected List<ItemStack> storage = new ArrayList<ItemStack>();
    protected List<ItemStack> tools = new ArrayList<ItemStack>();
    protected List<ItemStack> crafting = new ArrayList<ItemStack>();
    protected FluidStack leftFluidStack = FluidStack.EMPTY;
    protected FluidStack rightFluidStack = FluidStack.EMPTY;
    private final ItemStackHandler inventory = new ItemStackHandler(Tiers.NETHERITE.getStorageSlots());
    private final ItemStackHandler toolSlotsInventory = new ItemStackHandler(Tiers.NETHERITE.getToolSlots());
    private final ItemStackHandler craftingInventory = new ItemStackHandler(9);

    public BackpackTooltipComponent(ItemStack stack) {
        this.loadComponentData(stack.m_41783_());
    }

    public void loadComponentData(CompoundTag compound) {
        if (compound == null) {
            return;
        }
        this.loadFluidStacks(compound);
        this.storage = this.loadInventory(compound);
        this.crafting = this.loadCraftingInventory(compound);
        this.storage.addAll(this.crafting);
        this.storage = this.mergeStacks(this.storage);
        this.tools = this.loadTools(compound);
    }

    public void loadFluidStacks(CompoundTag compound) {
        if (compound.m_128441_("LeftTank")) {
            this.leftFluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("LeftTank"));
        }
        if (compound.m_128441_("RightTank")) {
            this.rightFluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("RightTank"));
        }
    }

    public List<ItemStack> loadInventory(CompoundTag compound) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (!compound.m_128441_("Inventory")) {
            return Collections.emptyList();
        }
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            list.add(this.inventory.getStackInSlot(i));
        }
        return list;
    }

    public List<ItemStack> mergeStacks(List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            ArrayList<ItemStack> uniqueList = new ArrayList<ItemStack>();
            for (ItemStack stack : stacks) {
                if (uniqueList.isEmpty()) {
                    uniqueList.add(stack);
                    continue;
                }
                boolean flag = false;
                for (int i = 0; i < uniqueList.size(); ++i) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)uniqueList.get(i)))) continue;
                    int count = stack.m_41613_() + ((ItemStack)uniqueList.get(i)).m_41613_();
                    uniqueList.set(i, stack.m_255036_(count));
                    flag = true;
                    break;
                }
                if (flag) continue;
                uniqueList.add(stack);
            }
            ArrayList<ItemStack> splittedList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : uniqueList) {
                if (itemStack.m_41613_() > 999) {
                    int count = itemStack.m_41613_();
                    int c = count / 999;
                    int reminder = count % 999;
                    for (int j = 0; j < c; ++j) {
                        splittedList.add(itemStack.m_255036_(999));
                    }
                    splittedList.add(itemStack.m_255036_(reminder));
                    continue;
                }
                splittedList.add(itemStack);
            }
            return splittedList;
        }
        return Collections.emptyList();
    }

    public List<ItemStack> loadTools(CompoundTag compound) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (!compound.m_128441_("ToolsInventory")) {
            return Collections.emptyList();
        }
        this.toolSlotsInventory.deserializeNBT(compound.m_128469_("ToolsInventory"));
        for (int i = 0; i < this.toolSlotsInventory.getSlots(); ++i) {
            if (this.toolSlotsInventory.getStackInSlot(i).m_41619_()) continue;
            list.add(this.toolSlotsInventory.getStackInSlot(i));
        }
        return list;
    }

    public List<ItemStack> loadCraftingInventory(CompoundTag compound) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (!compound.m_128441_("CraftingInventory")) {
            return Collections.emptyList();
        }
        this.craftingInventory.deserializeNBT(compound.m_128469_("CraftingInventory"));
        for (int i = 0; i < this.craftingInventory.getSlots(); ++i) {
            if (this.craftingInventory.getStackInSlot(i).m_41619_()) continue;
            list.add(this.craftingInventory.getStackInSlot(i));
        }
        return list;
    }
}

