/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.network.PacketDistributor;

public class AbilitySliderButton
extends Button {
    public AbilitySliderButton(TravelersBackpackScreen screen) {
        super(screen, 5, screen.container.getRows() <= 4 ? 26 : 56, 18, 11);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.screen.container.hasBlockEntity()) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) && !this.screen.toolSlotsWidget.isCoveringAbility()) {
                this.drawButton(guiGraphics, mouseX, mouseY, TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK);
            }
        } else if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.screen.m_6262_()).inventory.f_35978_) && this.screen.container.getScreenID() == 2 && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.container.getItemStack()) && !this.screen.toolSlotsWidget.isCoveringAbility()) {
            this.drawButton(guiGraphics, mouseX, mouseY, TravelersBackpackScreen.EXTRAS_TRAVELERS_BACKPACK);
        }
    }

    public void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY, ResourceLocation texture) {
        if (this.screen.container.getAbilityValue()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 114, 0, 95, 0);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 114, 12, 95, 12);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (!(this.screen.container.getScreenID() != 3 && this.screen.container.getScreenID() != 2 || !BackpackAbilities.isOnList(this.screen.container.getScreenID() == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) || !this.inButton(mouseX, mouseY) || this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) || this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget) || this.screen.toolSlotsWidget.isCoveringAbility())) {
            if (this.screen.container.getAbilityValue()) {
                ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
                list.add(Component.m_237115_((String)"screen.travelersbackpack.ability_enabled").m_7532_());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.screen.container.getItemStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.screen.container.getItemStack())) {
                    list.add(this.screen.container.getLastTime() == 0 ? Component.m_237115_((String)"screen.travelersbackpack.ability_ready").m_7532_() : Component.m_237115_((String)BackpackUtils.getConvertedTime(this.screen.container.getLastTime())).m_7532_());
                }
                guiGraphics.m_280245_(this.screen.getFont(), list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.enableBackpackAbilities || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.screen.container.getItemStack().m_41720_())) {
                guiGraphics.m_280557_(this.screen.getFont(), (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.screen.getFont(), (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.screen.container.hasBlockEntity()) {
            if (!this.screen.toolSlotsWidget.isCoveringAbility() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.container.getItemStack()) && this.inButton((int)mouseX, (int)mouseY) && !this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) && !this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.send((Object)new ServerboundAbilitySliderPacket(this.screen.container.getScreenID(), !this.screen.container.getAbilityValue()), PacketDistributor.SERVER.noArg());
                this.screen.playUIClickSound();
                return true;
            }
        } else if (this.screen.container.getScreenID() == 2 && !this.screen.toolSlotsWidget.isCoveringAbility() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.container.getItemStack()) && this.inButton((int)mouseX, (int)mouseY) && !this.screen.isWidgetVisible(3, this.screen.leftTankSlotWidget) && !this.screen.isWidgetVisible(4, this.screen.leftTankSlotWidget)) {
            TravelersBackpack.NETWORK.send((Object)new ServerboundAbilitySliderPacket(this.screen.container.getScreenID(), !this.screen.container.getAbilityValue()), PacketDistributor.SERVER.noArg());
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

