/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.TankScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.ControlTab;
import com.tiviacz.travelersbackpack.client.screens.widgets.CraftingWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.TankSlotWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventsHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends AbstractContainerScreen<TravelersBackpackBaseMenu>
implements MenuAccess<TravelersBackpackBaseMenu> {
    public static final ResourceLocation BACKGROUND_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_background.png");
    public static final ResourceLocation SLOTS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_slots.png");
    public static final ResourceLocation SETTINGS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_settings.png");
    public static final ResourceLocation EXTRAS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_extras.png");
    public List<IButton> buttons = new ArrayList<IButton>();
    public ControlTab controlTab;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public SortWidget sortWidget;
    public MemoryWidget memoryWidget;
    public TankSlotWidget leftTankSlotWidget;
    public TankSlotWidget rightTankSlotWidget;
    public CraftingWidget craftingWidget;
    public final ITravelersBackpackContainer container;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;
    private boolean fluidSlotsAsWidget;
    private int rows;

    public TravelersBackpackScreen(TravelersBackpackBaseMenu screenContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)screenContainer, inventory, component);
        this.container = screenContainer.container;
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 248;
        this.tankLeft = new TankScreen(this.container.getLeftTank(), 25, 7, 52 + this.container.getYOffset(), 16);
        this.tankRight = new TankScreen(this.container.getRightTank(), 207, 7, 52 + this.container.getYOffset(), 16);
        this.initScreen();
    }

    public Font getFont() {
        return this.f_96547_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initControlTab();
        this.initToolSlotsWidget();
        this.initSettingsTab();
        this.initTankSlotWidgets();
        this.initCraftingWidget();
        this.initButtons();
    }

    public void initTankSlotWidgets() {
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget = new TankSlotWidget(this, this.f_97735_, this.f_97736_, 28, 60);
            this.m_7787_(this.leftTankSlotWidget);
            this.rightTankSlotWidget = new TankSlotWidget(this, this.f_97735_ + 220, this.f_97736_, 28, 60);
            this.m_7787_(this.rightTankSlotWidget);
        }
    }

    public void initControlTab() {
        this.controlTab = new ControlTab(this, this.f_97735_ + 61, this.f_97736_ - 10, 50, 13);
        this.m_7787_(this.controlTab);
    }

    public void initToolSlotsWidget() {
        this.toolSlotsWidget = new ToolSlotsWidget(this, this.f_97735_ + 5, this.f_97736_ - 15, 18, 15);
        this.m_7787_(this.toolSlotsWidget);
    }

    public void initSettingsTab() {
        this.settingsWidget = new SettingsWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 10, 15, 18);
        this.m_7787_(this.settingsWidget);
        this.sortWidget = new SortWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 29, 15, 18);
        this.m_7787_(this.sortWidget);
        this.memoryWidget = new MemoryWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 48, 15, 18);
        this.m_7787_(this.memoryWidget);
    }

    public void initCraftingWidget() {
        this.craftingWidget = new CraftingWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 29, 15, 18);
        this.m_7787_(this.craftingWidget);
    }

    public void initButtons() {
        this.buttons.clear();
        this.buttons.add(new SleepingBagButton(this));
        this.buttons.add(new EquipButton(this));
        this.buttons.add(new UnequipButton(this));
        this.buttons.add(new AbilitySliderButton(this));
    }

    public void initScreen() {
        this.rows = Math.max(3, Math.min(this.container.getRows(), 7));
        this.fluidSlotsAsWidget = true;
        this.f_97727_ = 153;
        if (this.rows > 3) {
            this.f_97727_ = 153 + (this.rows - 3) * 18;
            if (this.rows > 4) {
                this.fluidSlotsAsWidget = false;
            }
        }
    }

    public void drawBackground(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(BACKGROUND_TRAVELERS_BACKPACK, x, y, 0, 0, this.f_97726_, 5);
        if (this.rows < this.container.getToolSlotsHandler().getSlots() && this.container.getSettingsManager().showToolSlots()) {
            int sub = this.container.getToolSlotsHandler().getSlots() - this.rows;
            for (int i = 0; i < sub; ++i) {
                guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x + 2, y + this.container.getYOffset() + 61 + 18 * i, 186, 61, 24, 18);
            }
            guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x + 2, y + this.container.getYOffset() + 61 + 18 * sub, 186, 80, 24, 2);
        }
        int offset = 5 + Math.abs(this.rows - 7) * 18;
        guiGraphics.m_280218_(BACKGROUND_TRAVELERS_BACKPACK, x, y + 5, 0, offset, this.f_97726_, this.f_97727_ - 5);
        if (TravelersBackpackConfig.enableLegacyGui) {
            this.drawSlotsLegacy(guiGraphics, x + 43, y + 6);
        } else {
            this.drawSlots(guiGraphics, x + 43, y + 6);
        }
        this.drawTank(guiGraphics, x + 24, y);
        this.drawTank(guiGraphics, x + 206, y);
        this.drawFluidSlot(guiGraphics, x + 5, y + 6);
        this.drawFluidSlot(guiGraphics, x + 225, y + 6);
    }

    public void drawSlots(GuiGraphics guiGraphics, int x, int y) {
        int rows = this.container.getRows();
        int additionalSlots = this.container.getHandler().getSlots() % 9;
        int gridX = 162;
        int gridY = (rows - 1) * 18;
        guiGraphics.m_280218_(SLOTS_TRAVELERS_BACKPACK, x, y, 43, 6, gridX, gridY);
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        gridX = additionalSlots * 18;
        gridY = 18;
        guiGraphics.m_280218_(SLOTS_TRAVELERS_BACKPACK, x, y + 18 * (rows - 1), 43, 6, gridX, gridY);
    }

    public void drawTank(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y + 6, 232, 38, 18, 18);
        for (int i = 1; i <= this.rows - 2; ++i) {
            guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y + 6 + 18 * i, 232, 57, 18, 18);
        }
        guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y + 6 + 18 * (this.rows - 1), 232, 76, 18, 18);
    }

    public void drawFluidSlot(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y, 213, 38, 18, this.fluidSlotsAsWidget ? 18 : 48);
    }

    public void drawSlotsLegacy(GuiGraphics guiGraphics, int x, int y) {
        int rows = this.container.getRows() - 1;
        int additionalSlots = this.container.getHandler().getSlots() % 9;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.drawSlotLegacy(guiGraphics, x + j * 18, y + i * 18, 213, 0);
            }
        }
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        for (int j = 0; j < additionalSlots; ++j) {
            this.drawSlotLegacy(guiGraphics, x + j * 18, y + rows * 18, 213, 0);
        }
    }

    public void drawSlotLegacy(GuiGraphics guiGraphics, int x, int y, int vOffset, int uWidth) {
        guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y, vOffset, uWidth, 18, 18);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.container.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(this, guiGraphics);
        }
        if (!this.container.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(this, guiGraphics);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.controlTab.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.toolSlotsWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.rightTankSlotWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.settingsWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).filter(w -> ((WidgetBase)w).isSettingsChild() && ((WidgetBase)w).isVisible()).forEach(w -> ((WidgetBase)w).m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, this.tankLeft.getTankTooltip(this.container.m_58904_()), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, this.tankRight.getTankTooltip(this.container.m_58904_()), mouseX, mouseY);
        }
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.craftingWidget.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean isWidgetVisible(int rowsCount, TankSlotWidget widget) {
        return this.container.getRows() == rowsCount && widget.isVisible();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.craftingWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawBackground(guiGraphics, x, y);
        this.drawToolSlots(guiGraphics);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawToolSlots(GuiGraphics guiGraphics) {
        if (this.container.getSettingsManager().showToolSlots()) {
            boolean enableLegacy = TravelersBackpackConfig.enableLegacyGui;
            for (int i = 0; i < this.container.getToolSlotsHandler().getSlots(); ++i) {
                guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i, 232, enableLegacy ? 0 : 19, 18, 18);
                if (enableLegacy) continue;
                guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i, 76, 0, 18, 18);
            }
        }
    }

    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (!this.container.getSlotManager().getUnsortableSlots().isEmpty() && !this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().getUnsortableSlots().forEach(i -> guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(i.intValue() + 1)).f_40220_, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(i.intValue() + 1)).f_40221_, 77, 20, 16, 16));
        }
    }

    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
            this.container.getSlotManager().getMemorySlots().forEach(pair -> {
                if (this.container.getSlotManager().isSelectorActive((byte)1)) {
                    guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40220_, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40221_, 115, 24, 16, 16);
                }
                if (!((TravelersBackpackBaseMenu)this.f_97732_).m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41619_()) {
                    return;
                }
                ItemStack itemstack = (ItemStack)pair.getSecond();
                guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40220_, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40221_);
                guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40220_, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40221_, this.getGuiLeft() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40220_ + 16, this.getGuiTop() + ((TravelersBackpackBaseMenu)this.m_6262_()).m_38853_((int)(((Integer)pair.getFirst()).intValue() + 1)).f_40221_ + 16, 0x30FFFFFF);
            });
        }
    }

    protected boolean m_7467_(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((TravelersBackpackBaseMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (GuiEventListener widget : this.m_6702_()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).m_5953_(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.f_97726_) || pMouseY >= (double)(pGuiTop + this.f_97727_);
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        super.m_6597_(slot, slotId, button, type);
        this.selectSlots(slot, button);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        Slot slot = this.getSlotUnderMouse();
        this.selectSlots(slot, pButton);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void selectSlots(Slot slot, int button) {
        if (slot != null && slot.f_40219_ >= 1 && slot.f_40219_ <= this.container.getHandler().getSlots()) {
            if (this.container.getSlotManager().isSelectorActive((byte)0)) {
                if (button == 0 && !this.container.getSlotManager().isSlot((byte)0, slot.f_40219_ - 1)) {
                    this.container.getSlotManager().setUnsortableSlot(slot.f_40219_ - 1);
                }
                if (button == 1 && this.container.getSlotManager().isSlot((byte)0, slot.f_40219_ - 1)) {
                    this.container.getSlotManager().setUnsortableSlot(slot.f_40219_ - 1);
                }
            } else if (this.container.getSlotManager().isSelectorActive((byte)1)) {
                if (button == 0 && !this.container.getSlotManager().isSlot((byte)1, slot.f_40219_ - 1) && !slot.m_7993_().m_41619_()) {
                    this.container.getSlotManager().setMemorySlot(slot.f_40219_ - 1, slot.m_7993_());
                }
                if (button == 1 && this.container.getSlotManager().isSlot((byte)1, slot.f_40219_ - 1)) {
                    this.container.getSlotManager().setMemorySlot(slot.f_40219_ - 1, slot.m_7993_());
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) && !this.sortWidget.m_5953_(mouseX, mouseY) || this.container.getSlotManager().isSelectorActive((byte)1) && !this.memoryWidget.m_5953_(mouseX, mouseY)) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        if (!this.container.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.send((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 1.0), PacketDistributor.SERVER.noArg());
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.m_58904_(), this.container.getScreenID());
            }
        }
        if (!this.container.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.send((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 2.0), PacketDistributor.SERVER.noArg());
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.m_58904_(), this.container.getScreenID());
            }
        }
        this.buttons.forEach(b -> b.mouseClicked(mouseX, mouseY, button));
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.m_9236_().m_5594_(((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventsHandler.OPEN_INVENTORY.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

