/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final FluidTank tank;

    public TankScreen(FluidTank tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<Component> getTankTooltip(Level level) {
        String fluidAmount;
        FluidStack fluidStack = this.tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getDisplayName().getString() : I18n.m_118938_((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        String string = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + this.tank.getCapacity() : I18n.m_118938_((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.getTag() != null && fluidStack.getTag().m_128441_("Potion")) {
            fluidName = null;
            TankScreen.setPotionDescription(PotionUtils.m_43547_((ItemStack)FluidUtils.getItemStackFromFluidStack(fluidStack)), tankTips, level);
        }
        if (fluidName != null) {
            tankTips.add((Component)Component.m_237113_((String)fluidName));
        }
        tankTips.add((Component)Component.m_237113_((String)fluidAmount));
        return tankTips;
    }

    public static void setPotionDescription(List<MobEffectInstance> pEffects, List<Component> pTooltips, Level level) {
        ArrayList list = Lists.newArrayList();
        if (pEffects.isEmpty()) {
            pTooltips.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance mobeffectinstance : pEffects) {
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                Map map = mobeffect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        list.add(new Pair((Object)((Attribute)entry.getKey()), (Object)((AttributeModifierTemplate)entry.getValue()).m_293134_(mobeffectinstance.m_19564_())));
                    }
                }
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                }
                if (!mobeffectinstance.m_267633_(20)) {
                    mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)1.0f, (float)(level == null ? 20.0f : level.m_304826_().m_306179_()))});
                }
                pTooltips.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        }
        if (!list.isEmpty()) {
            pTooltips.add(CommonComponents.f_237098_);
            pTooltips.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list) {
                AttributeModifier attributemodifier = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier.m_22218_();
                double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier.m_22218_() : attributemodifier.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                pTooltips.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public void drawScreenFluidBar(TravelersBackpackScreen screen, GuiGraphics guiGraphics) {
        RenderUtils.renderScreenTank(guiGraphics, this.tank, screen.getGuiLeft() + this.startX, screen.getGuiTop() + this.startY, 0.0, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackScreen screen, int mouseX, int mouseY) {
        return screen.getGuiLeft() + this.startX <= mouseX && mouseX <= this.startX + this.width + screen.getGuiLeft() && this.startY + screen.getGuiTop() <= mouseY && mouseY <= this.startY + this.height + screen.getGuiTop();
    }
}

