/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.client.renderer.RenderData;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class TravelersBackpackBlockModel {
    public ModelPart mainBody;
    public ModelPart tankLeftTop;
    public ModelPart tankRightTop;
    public ModelPart sleepingBag;
    public ModelPart sleepingBagExtras;
    public ModelPart leftStrap;
    public ModelPart rightStrap;
    public ModelPart top;
    public ModelPart bottom;
    public ModelPart pocketFace;
    public ModelPart tankLeftBottom;
    public ModelPart tankLeftWall4;
    public ModelPart tankLeftWall3;
    public ModelPart tankLeftWall2;
    public ModelPart tankLeftWall1;
    public ModelPart tankRightBottom;
    public ModelPart tankRightWall2;
    public ModelPart tankRightWall1;
    public ModelPart tankRightWall3;
    public ModelPart tankRightWall4;
    public ModelPart sleepingBagStrapLeftMid;
    public ModelPart sleepingBagStrapRightBottom;
    public ModelPart sleepingBagStrapLeftBottom;
    public ModelPart sleepingBagStrapRightMid;
    public ModelPart sleepingBagStrapRightTop;
    public ModelPart sleepingBagStrapLeftTop;
    public ModelPart villagerNose;
    public ModelPart wolfNose;
    public ModelPart foxNose;
    public ModelPart ocelotNose;
    public ModelPart pigNose;

    public TravelersBackpackBlockModel(ModelPart rootPart) {
        this.mainBody = rootPart.m_171324_("main_body");
        this.top = this.mainBody.m_171324_("top");
        this.bottom = this.mainBody.m_171324_("bottom");
        this.pocketFace = this.mainBody.m_171324_("pocketFace");
        this.leftStrap = this.mainBody.m_171324_("leftStrap");
        this.rightStrap = this.mainBody.m_171324_("rightStrap");
        this.tankLeftTop = rootPart.m_171324_("tankLeftTop");
        this.tankLeftBottom = this.tankLeftTop.m_171324_("tankLeftBottom");
        this.tankLeftWall1 = this.tankLeftBottom.m_171324_("tankLeftWall1");
        this.tankLeftWall2 = this.tankLeftBottom.m_171324_("tankLeftWall2");
        this.tankLeftWall3 = this.tankLeftBottom.m_171324_("tankLeftWall3");
        this.tankLeftWall4 = this.tankLeftBottom.m_171324_("tankLeftWall4");
        this.tankRightTop = rootPart.m_171324_("tankRightTop");
        this.tankRightBottom = this.tankRightTop.m_171324_("tankRightBottom");
        this.tankRightWall1 = this.tankRightBottom.m_171324_("tankRightWall1");
        this.tankRightWall2 = this.tankRightBottom.m_171324_("tankRightWall2");
        this.tankRightWall3 = this.tankRightBottom.m_171324_("tankRightWall3");
        this.tankRightWall4 = this.tankRightBottom.m_171324_("tankRightWall4");
        this.sleepingBag = rootPart.m_171324_("sleepingBag");
        this.sleepingBagExtras = rootPart.m_171324_("sleepingBagExtras");
        this.sleepingBagStrapLeftTop = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftTop");
        this.sleepingBagStrapLeftMid = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftMid");
        this.sleepingBagStrapLeftBottom = this.sleepingBagExtras.m_171324_("sleepingBagStrapLeftBottom");
        this.sleepingBagStrapRightTop = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightTop");
        this.sleepingBagStrapRightMid = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightMid");
        this.sleepingBagStrapRightBottom = this.sleepingBagExtras.m_171324_("sleepingBagStrapRightBottom");
        this.villagerNose = rootPart.m_171324_("villagerNose");
        this.ocelotNose = rootPart.m_171324_("ocelotNose");
        this.pigNose = rootPart.m_171324_("pigNose");
        this.foxNose = rootPart.m_171324_("foxNose");
        this.wolfNose = rootPart.m_171324_("wolfNose");
    }

    public void render(ITravelersBackpackContainer container, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean isColorable = false;
        ResourceLocation loc = ResourceUtils.getBackpackTexture(container.getItemStack().m_41720_());
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        if ((container.hasBlockEntity() ? container.hasColor() : container.getItemStack().m_41783_() != null) && (container.hasBlockEntity() || BackpackDyeRecipe.hasColor(container.getItemStack())) && container.getItemStack().m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            isColorable = true;
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
        }
        if (isColorable) {
            this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(container.hasBlockEntity() ? container.getColor() : BackpackDyeRecipe.getColor(container.getItemStack()));
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104306_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            if (!container.isSleepingBagDeployed()) {
                this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = ResourceUtils.getSleepingBagTexture(container.getSleepingBagColor());
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
        } else {
            this.tankLeftTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            if (!container.isSleepingBagDeployed()) {
                this.sleepingBagExtras.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = ResourceUtils.getSleepingBagTexture(container.getSleepingBagColor());
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
                this.sleepingBag.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
                loc = ResourceUtils.getBackpackTexture(container.getItemStack().m_41720_());
                vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            }
            if (container.getItemStack().m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.PIG_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
            }
            if (container.getItemStack().m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                vertexConsumer = buffer.m_6299_(container.hasBlockEntity() ? RenderType.m_110470_((ResourceLocation)ResourceUtils.getBackpackTexture(container.getItemStack().m_41720_())) : RenderType.m_110467_((ResourceLocation)ResourceUtils.getBackpackTexture(container.getItemStack().m_41720_())));
            }
            this.mainBody.m_104301_(poseStack, vertexConsumer, combinedLightIn, combinedOverlayIn);
        }
        RenderUtils.renderFluidInTank(container, container.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(container, container.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
    }

    public void renderByItem(RenderData renderData, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        boolean isColorable = false;
        ResourceLocation loc = ResourceUtils.getBackpackTexture(renderData.getItemStack().m_41720_());
        VertexConsumer ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
        if (renderData.getItemStack().m_41783_() != null && BackpackDyeRecipe.hasColor(renderData.getItemStack()) && renderData.getItemStack().m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            isColorable = true;
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
        }
        if (isColorable) {
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(renderData.getItemStack()));
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104306_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.mainBody.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankLeftTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = ResourceUtils.getSleepingBagTexture(renderData.getSleepingBagColor());
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        } else {
            this.tankLeftTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.tankRightTop.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            this.sleepingBagExtras.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = ResourceUtils.getSleepingBagTexture(renderData.getSleepingBagColor());
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            this.sleepingBag.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            loc = ResourceUtils.getBackpackTexture(renderData.getItemStack().m_41720_());
            ivertexbuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)loc));
            if (renderData.getItemStack().m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.foxNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.WOLF_TRAVELERS_BACKPACK.get()) {
                this.wolfNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                this.villagerNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.PIG_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.HORSE_TRAVELERS_BACKPACK.get()) {
                this.pigNose.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
            if (renderData.getItemStack().m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || renderData.getItemStack().m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get()) {
                ivertexbuilder = buffer.m_6299_(RenderType.m_110467_((ResourceLocation)ResourceUtils.getBackpackTexture(renderData.getItemStack().m_41720_())));
            }
            this.mainBody.m_104301_(poseStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        }
        RenderUtils.renderFluidInTank(null, renderData.getLeftTank(), poseStack, buffer, combinedLightIn, -0.65f, -0.565f, -0.24f);
        RenderUtils.renderFluidInTank(null, renderData.getRightTank(), poseStack, buffer, combinedLightIn, 0.23f, -0.565f, -0.24f);
    }
}

