/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.mojang.datafixers.util.Either;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.f_61428_;
    protected static final VoxelShape SLEEPING_BAG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SLEEPING_BAG_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_EAST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_SOUTH = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SLEEPING_BAG_WEST = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SleepingBagBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties.m_280606_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.FALSE)).m_61124_((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((BedPart)state.m_61143_(PART)) {
            default -> throw new IncompatibleClassChangeError();
            case BedPart.FOOT -> SLEEPING_BAG;
            case BedPart.HEAD -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        yield SLEEPING_BAG_EAST;
                    }
                    case SOUTH: {
                        yield SLEEPING_BAG_SOUTH;
                    }
                    case WEST: {
                        yield SLEEPING_BAG_WEST;
                    }
                }
                yield SLEEPING_BAG_NORTH;
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_(PART) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!SleepingBagBlock.m_49488_((Level)level)) {
            level.m_7471_(pos, false);
            BlockPos var7 = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (level.m_8055_(var7).m_60713_((Block)this)) {
                level.m_7471_(var7, false);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
            if (!this.m_49490_(level, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.startSleepInBed(serverPlayer, pos).ifLeft(p_49477_ -> {
                if (p_49477_.m_36423_() != null) {
                    player.m_5661_(p_49477_.m_36423_(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public Either<Player.BedSleepingProblem, Unit> startSleepInBed(ServerPlayer player, BlockPos pos) {
        Optional<BlockPos> optAt = Optional.of(pos);
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)player, optAt);
        if (ret != null) {
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
            }
            return Either.left((Object)ret);
        }
        Direction direction = (Direction)player.m_9236_().m_8055_(pos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (!player.m_5803_() && player.m_6084_()) {
            if (!player.m_9236_().m_6042_().f_63858_()) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                }
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!this.bedInRange((Player)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                }
                return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (this.bedBlocked((Player)player, pos, direction)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                }
                return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            }
            if (!ForgeEventFactory.onSleepingTimeCheck((Player)player, optAt)) {
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                }
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!player.m_7500_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vector3d = Vec3.m_82539_((Vec3i)pos);
                List list = player.m_9236_().m_6443_(Monster.class, new AABB(vector3d.m_7096_() - 8.0, vector3d.m_7098_() - 5.0, vector3d.m_7094_() - 8.0, vector3d.m_7096_() + 8.0, vector3d.m_7098_() + 5.0, vector3d.m_7094_() + 8.0), p_241146_1_ -> p_241146_1_.m_6935_((Player)player));
                if (!list.isEmpty()) {
                    if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                        player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                    }
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                Either either = player.m_7720_(pos).ifRight(p_241144_1_ -> {
                    player.m_36220_(Stats.f_12969_);
                    CriteriaTriggers.f_10583_.m_222618_(player);
                });
                ((ServerLevel)player.m_9236_()).m_8878_();
                if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                    player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
                }
                return either;
            }
            player.m_5802_(pos);
            player.f_36110_ = 0;
            player.m_36220_(Stats.f_12969_);
            CriteriaTriggers.f_10583_.m_222618_(player);
            ((ServerLevel)player.m_9236_()).m_8878_();
            if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
            }
            return Either.right((Object)Unit.INSTANCE);
        }
        if (TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
            player.m_9158_(player.m_9236_().m_46472_(), pos, player.m_146908_(), true, true);
        }
        return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    private boolean bedInRange(Player player, BlockPos pos, Direction direction) {
        if (direction == null) {
            return false;
        }
        return this.isReachableBedBlock(player, pos) || this.isReachableBedBlock(player, pos.m_121945_(direction.m_122424_()));
    }

    private boolean isReachableBedBlock(Player player, BlockPos p_241158_1_) {
        Vec3 vector3d = Vec3.m_82539_((Vec3i)p_241158_1_);
        return Math.abs(player.m_20185_() - vector3d.m_7096_()) <= 3.0 && Math.abs(player.m_20186_() - vector3d.m_7098_()) <= 2.0 && Math.abs(player.m_20189_() - vector3d.m_7094_()) <= 3.0;
    }

    private boolean bedBlocked(Player player, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_7494_();
        return !this.freeAt(player, blockpos) || !this.freeAt(player, blockpos.m_121945_(direction.m_122424_()));
    }

    protected boolean freeAt(Player player, BlockPos pos) {
        return !player.m_9236_().m_8055_(pos).m_60828_((BlockGetter)player.m_9236_(), pos);
    }

    private boolean m_49490_(Level level, BlockPos pos) {
        List var3 = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (var3.isEmpty()) {
            return false;
        }
        ((Villager)var3.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float factor) {
        super.m_142072_(level, state, pos, entity, factor * 0.75f);
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.m_49456_(entity);
        }
    }

    private void m_49456_(Entity entity) {
        Vec3 var2 = entity.m_20184_();
        if (var2.f_82480_ < 0.0) {
            double var3 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(var2.f_82479_, -var2.f_82480_ * 0.3300000262260437 * var3, var2.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        if (direction == SleepingBagBlock.m_49533_((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return newState.m_60713_((Block)this) && newState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)newState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, accessor, pos, newPos);
    }

    private static Direction m_49533_(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        boolean isFoot = state.m_61143_(PART) == BedPart.FOOT;
        BlockPos backpackPos = isFoot ? pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()) : pos.m_5484_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_(), 2);
        BlockEntity blockEntity = level.m_7702_(backpackPos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            blockEntity2.setSleepingBagDeployed(false);
        }
        return super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, CAN_DROP});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemstack) {
        super.m_6402_(level, pos, state, livingEntity, itemstack);
        if (!level.f_46443_) {
            BlockPos var6 = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            level.m_7731_(var6, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos var3 = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)var3.m_123341_(), (int)pos.m_123342_(), (int)var3.m_123343_());
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        if (!((Boolean)pState.m_61143_((Property)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.m_49635_(pState, pParams);
    }

    public BlockEntity m_142194_(BlockPos p_152175_, BlockState p_152176_) {
        return null;
    }
}

