/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.LogicalSide;

public class PacketContext {
    private final CustomPayloadEvent.Context context;

    public PacketContext(CustomPayloadEvent.Context context) {
        this.context = context;
    }

    public CoreSide getHandlingSide() {
        return this.context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public CoreSide getOriginatingSide() {
        return this.context.getDirection().getOriginationSide() == LogicalSide.CLIENT ? CoreSide.CLIENT : CoreSide.SERVER;
    }

    public Player getSendingPlayer() {
        return this.context.getSender();
    }

    public Level getWorld() {
        return this.getHandlingSide() == CoreSide.CLIENT ? ClientUtils.getWorld() : this.getSendingPlayer().m_9236_();
    }

    public void queueTask(Runnable task) {
        if (this.getHandlingSide() == CoreSide.SERVER) {
            this.context.enqueueWork(task);
        } else {
            ClientUtils.queueTask(task);
        }
    }

    @Deprecated
    public CustomPayloadEvent.Context getUnderlyingContext() {
        return this.context;
    }
}

