/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.crafting.conditions.ICondition;

class ResourceConditions {
    private static final Map<ResourceConditionSerializer<?>, Codec<? extends ICondition>> TO_UNDERLYING_MAP = new HashMap();

    ResourceConditions() {
    }

    static ConditionWrapper wrap(ResourceCondition condition) {
        return new ConditionWrapper(condition);
    }

    static Codec<? extends ICondition> serializerCodec(final ResourceConditionSerializer<?> serializer) {
        return TO_UNDERLYING_MAP.computeIfAbsent(serializer, s -> Codec.of((Encoder)new Encoder<ConditionWrapper>(){

            public <T> DataResult<T> encode(ConditionWrapper input, DynamicOps<T> ops, T prefix) {
                JsonObject json = new JsonObject();
                try {
                    serializer.serialize(json, input.condition);
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Failed to encode condition: " + e.getMessage());
                }
                return DataResult.success((Object)json);
            }
        }, (Decoder)new Decoder<ConditionWrapper>(){

            public <T> DataResult<Pair<ConditionWrapper, T>> decode(DynamicOps<T> ops, T input) {
                try {
                    return DataResult.success((Object)Pair.of((Object)new ConditionWrapper((ResourceCondition)serializer.deserialize((JsonObject)input)), input));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to decode condition for serializer class '" + serializer.getClass() + "'!", e);
                }
            }
        }));
    }

    private static class ConditionWrapper
    implements ICondition {
        private final ResourceCondition condition;
        private Codec<? extends ICondition> codec;

        ConditionWrapper(ResourceCondition condition) {
            this.condition = condition;
        }

        public boolean test(ICondition.IContext context) {
            return this.condition.test(new ResourceConditionContext(context));
        }

        public Codec<? extends ICondition> codec() {
            return ResourceConditions.serializerCodec(this.condition.getSerializer());
        }
    }
}

