/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class VanillaOre
extends AbstractOre
implements IRelatedUnit {
    protected final UnitId oreId;
    protected final Generation generation;
    protected final IntBounds veinsInChunk;
    protected final IntBounds blocksInVein;

    public VanillaOre(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.oreId = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"oreId", (UnitId)props.id, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n");
        this.generation = Generation.from(config, category, "Generation type used for this ore. Possible values:\n    VANILLA - vanilla generation without any changes,\n    CUSTOM - generation according to this config,\n    NONE - no generation at all.\nNote that changing this setting requires a WORLD RESTART in order to update every biome's features.");
        this.veinsInChunk = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"VeinsInChunk", (IntBounds)props.veins, (IntBounds)Properties.SIZE_BOUNDS, (String)"Number of ore veins to generate in each chunk.");
        this.blocksInVein = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"BlocksInVein", (IntBounds)props.size, (IntBounds)Properties.SIZE_BOUNDS, (String)"Number of ore blocks in each vein.");
        this.pickState(this.oreId).ifPresent(ore -> this.replacements.add(this.replaceableBlocks, new WeightedOre((BlockState)ore, 1)));
        this.saveConfig();
    }

    public UnitId getRelatedId() {
        return this.oreId;
    }

    public Generation getGeneration() {
        return this.generation;
    }

    public IntBounds getVeinsInChunk() {
        return this.veinsInChunk;
    }

    public IntBounds getBlocksInVein() {
        return this.blocksInVein;
    }

    @Override
    protected int generate(final WorldGenLevel world, final BlockPos start, int amount, final boolean testing, Random random) {
        return new OreChain((LevelAccessor)world, start, amount, this.miscellaneous, random){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return VanillaOre.this.replaceWithOre((LevelAccessor)world, pos, testing, this.random);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return VanillaOre.this.isValidPosition(world, pos, start, start, testing) && VanillaOre.this.canBeReplaced((LevelAccessor)world, pos, testing);
            }
        }.generate().getCount();
    }

    public boolean matches(Holder<PlacedFeature> holder) {
        FeatureConfiguration featureConfiguration;
        Feature feature;
        if (!holder.m_203633_()) {
            return false;
        }
        ConfiguredFeature configuredFeature = ((PlacedFeature)holder.m_203334_()).m_191781_().findFirst().orElse(null);
        if (configuredFeature != null && ((feature = configuredFeature.f_65377_()) == Feature.f_65731_ || feature == Feature.f_159727_) && (featureConfiguration = configuredFeature.f_65378_()) instanceof OreConfiguration) {
            OreConfiguration configuration = (OreConfiguration)featureConfiguration;
            if (this.matches(configuration.f_161005_)) {
                return true;
            }
        }
        return false;
    }

    public boolean matches(List<OreConfiguration.TargetBlockState> targetStates) {
        return targetStates.stream().findFirst().map(target -> this.getRelatedId().matches(target.f_161033_)).orElse(false);
    }

    @Override
    public boolean isValid() {
        return !this.replacements.isEmpty();
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        protected static final IntBounds SIZE_BOUNDS = IntBounds.between((Integer)1, (Integer)256);
        public IntBounds size = IntBounds.ZERO;
        public IntBounds veins = IntBounds.ZERO;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> overworld() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T veins(int max) {
            this.veins = IntBounds.between((Integer)max, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T size(int max) {
            this.size = IntBounds.between((Integer)1, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Generation {
        VANILLA,
        CUSTOM,
        NONE;


        public static Generation from(UnitConfig config, String category, String comment) {
            String name = UnitConfig.getStr((UnitConfig)config, (String)category, (String)"generation", (String)"vanilla", (String)comment);
            for (Generation type : Generation.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            AdLods.getInstance().getLogger().error("Invalid generation type: " + name);
            return VANILLA;
        }
    }
}

