/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenResult;
import com.endertech.minecraft.mods.adlods.deposit.DepositOreChain;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.world.WorldDeposits;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class Deposit
extends AbstractOre {
    public static ForgeConfigSpec.ConfigValue<Double> globalSizeMultiplier;
    public static ForgeConfigSpec.ConfigValue<Double> globalSpawnRateMultiplier;
    protected final boolean enabled;
    protected final String name;
    protected final IntBounds size;
    protected final int rarity;
    protected final CommonCollect.WeightedList<WeightedOre> ores;
    protected final Percentage chance;
    protected final Indicator indicator;

    public Deposit(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.name = props.name;
        this.enabled = UnitConfig.readConfigEnabled((UnitConfig)config, (boolean)true);
        this.size = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Size", (IntBounds)props.size, (IntBounds)Size.BOUNDS, (String)"Size limits (in blocks) of this deposit.");
        this.rarity = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"rarity", (int)props.rarity, (IntBounds)Rarity.BOUNDS, (String)"Rarity (in chunks) of this deposit.\nHigher values give more rare deposit spawning.\nExample: value of 1000, means that 1 deposit can be spawned per 1000 chunks,\n that gives us 1 / 1000 * 100% = 0.1% chance of spawing per chunk.");
        this.chance = Percentage.value((float)(Percentage.from((int)1, (int)this.rarity).getValue() * ((Double)globalSpawnRateMultiplier.get()).floatValue()));
        this.indicator = new Indicator(config, category, props.indicators);
        this.ores = Deposit.parseOresFrom(UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"ores", (String[])props.ores, (String)"List of ores and their weights for this deposit.\nSyntax: oreId [, weight]\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nWeight is used to define the proportions of the ores. For example, the definition:\n     #forge:ores/gold, 1\n     #forge:ores/iron, 5\n means that gold and iron will be in the proportion 1 to 5."), x$0 -> this.pickState((UnitId)x$0));
        this.ores.getElements().forEach(ore -> this.replacements.add(this.replaceableBlocks, (WeightedOre)ore));
        this.saveConfig();
    }

    public static Deposit in(Path dir, Properties<?> props) {
        return new Deposit(UnitConfig.in((Path)dir, (String)props.name), props);
    }

    public static CommonCollect.WeightedList<WeightedOre> parseOresFrom(String[] array, Function<UnitId, Optional<BlockState>> mapper) {
        CommonCollect.WeightedList ores = new CommonCollect.WeightedList();
        Parsers.UnitId_OptInteger parser = new Parsers.UnitId_OptInteger(IntBounds.INTEGER_POSITIVE, ",");
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            try {
                UnitId id = parser.getId((CharSequence)str);
                int weight = parser.getInteger((CharSequence)str).orElse(1);
                mapper.apply(id).ifPresent(state -> ores.add((CommonCollect.IWeighted)new WeightedOre((BlockState)state, weight)));
            }
            catch (Exception e) {
                parser.logError((AbstractForgeMod)AdLods.getInstance(), "ore", (CharSequence)str, e);
            }
        }
        return ores;
    }

    public boolean placeIndicatorIfFullsized(WorldGenLevel level, DepositGenResult result) {
        int minSize = Math.round((float)this.size.getMin().intValue() * ((Double)globalSizeMultiplier.get()).floatValue());
        if (result.size >= minSize) {
            return this.placeIndicator(level, result);
        }
        return false;
    }

    public boolean placeIndicator(WorldGenLevel level, DepositGenResult result) {
        return this.indicator.placeFor(level, result) > 0;
    }

    public DepositGenResult generateAt(WorldGenLevel level, ChunkPos chunkPos, Random random) {
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        return this.generateAt(level, chunkBounds.getX().randomBetween(random), chunkBounds.getZ().randomBetween(random), random);
    }

    public DepositGenResult generateAt(WorldGenLevel level, int posX, int posZ, Random random) {
        BlockPos startPos = new BlockPos(posX, this.altitude.randomBetween(random).intValue(), posZ);
        int amount = Math.round((float)this.size.randomBetween(random).intValue() * ((Double)globalSizeMultiplier.get()).floatValue());
        return this.generateAt(level, startPos, amount, false, random);
    }

    public DepositGenResult generateAt(WorldGenLevel level, BlockPos startPos, int amount, boolean testing, Random random) {
        if (!testing && !this.inAllowedDimenstion((ServerLevelAccessor)level)) {
            ForgeEndertech.debugMsg((String)("Not in allowable dimension for " + this.getName() + " deposit"));
            return new DepositGenResult(this.getName(), startPos, 0, 0);
        }
        int count = this.generate(level, startPos, amount, testing, random);
        DepositGenResult result = new DepositGenResult(this.getName(), startPos, count, amount - count);
        WorldDeposits.get(level.m_6018_()).saveGenResult(result);
        ForgeEndertech.debugMsg((String)result.toString());
        return result;
    }

    @Override
    protected int generate(WorldGenLevel level, BlockPos startPos, int amount, boolean testing, Random random) {
        return this.generate(level, startPos, startPos, amount, testing, random, 0);
    }

    protected int generate(final WorldGenLevel world, final BlockPos origin, final BlockPos start, int amount, final boolean testing, Random random, int part) {
        return new DepositOreChain((LevelAccessor)world, start, amount, this.miscellaneous, random){

            @Override
            public void saveDeferredEntryPoint(BlockPos pos) {
                WorldDeposits.get(world.m_6018_()).saveDeferredEntryPoint(pos, origin);
            }

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return Deposit.this.replaceWithOre((LevelAccessor)world, pos, testing, this.random);
            }

            protected boolean isValidBlock(BlockPos pos) {
                ChunkPos chunk = new ChunkPos(pos);
                if (this.inFullWorld() || this.inGenRegion(chunk)) {
                    return Deposit.this.isValidPosition(world, pos, start, origin, testing) && Deposit.this.canBeReplaced((LevelAccessor)world, pos, testing);
                }
                if (this.inDeferredRegion(chunk)) {
                    return Deposit.this.withinHeightBounds(world, pos, start, origin, testing);
                }
                if (testing && this.inFarRegion(chunk)) {
                    return Deposit.this.withinHeightBounds(world, pos, start, origin, testing);
                }
                return false;
            }
        }.generate().getCount();
    }

    public boolean isOreBlock(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return this.replacements.containOreWith(state) || GameWorld.isOreBlock((LevelReader)level, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public boolean isValid() {
        return this.enabled && !this.name.isEmpty() && !this.replacements.isEmpty() && CommonMath.notZero((double)this.getChance().getValue()) && this.size.getMin() > 0;
    }

    public Percentage getChance() {
        return this.chance;
    }

    public String getName() {
        return this.name;
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        public final String name;
        public IntBounds size = IntBounds.ZERO;
        public int rarity = 0;
        public String[] ores = new String[0];
        public String[] indicators = new String[0];

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass);
            this.name = name;
        }

        public static Properties<?> deposit(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            if (name.startsWith("nether_") || name.endsWith("_nether")) {
                return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
            }
            if (name.startsWith("end_") || name.endsWith("_end")) {
                return (Properties)((Object)props.dimension(Dimensions.THE_END));
            }
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> overworld(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T size(int min, int max) {
            this.size = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T rarity(int rarity) {
            this.rarity = rarity;
            return (T)((Object)((Properties)this.self));
        }

        public T ores(String ... ores) {
            this.ores = ores;
            return (T)((Object)((Properties)this.self));
        }

        public T indicators(String ... indicators) {
            this.indicators = indicators;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Size
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)1, (Integer)256000);
        public static final Size ZERO = new Size(0, 0);

        public static Size from(IntBounds bounds) {
            return new Size(bounds.getMin(), bounds.getMax());
        }

        public Size(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Rarity
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)1, (Integer)256000);

        public Rarity(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Altitude
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.INTEGER;
        public static final Altitude ZERO = new Altitude(0, 0);

        public static Altitude from(IntBounds bounds) {
            return new Altitude(bounds.getMin(), bounds.getMax());
        }

        public Altitude(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }
}

