/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SteepRoof
extends RoofBlock {
    protected static final VoxelShape OCCLUSION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final VoxelShape OCCLUSION_BOTTOM = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public SteepRoof(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)SHAPE, (Comparable)SteepRoof.getStairsShape((BlockGetter)access, pos, (Direction)state.m_61143_((Property)FACING), (Half)state.m_61143_(HALF))) : super.m_7417_(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.m_8055_(pos.m_121945_(direction));
        if (SteepRoof.isSteepRoof(blockstate) && half == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && SteepRoof.canTakeShape(direction1.m_122424_(), blockstate, reader, pos)) {
            return direction1 == direction.m_122428_() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (SteepRoof.isSteepRoof(blockstate1) && half == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != facing.m_122434_() && SteepRoof.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.m_122428_() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.m_8055_(pos.m_121945_(dir));
        return !SteepRoof.isSteepRoof(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != state.m_61143_(HALF);
    }

    public static boolean isSteepRoof(BlockState state) {
        return state.m_60734_() instanceof SteepRoof;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        if (state.m_61143_(HALF) == Half.BOTTOM) {
            return OCCLUSION;
        }
        return OCCLUSION_BOTTOM;
    }
}

