/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen.noise;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.biome.Biome;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.noise.WeightedRandomLayer;

public class InitialLayer
extends WeightedRandomLayer<WeightedEntry.Wrapper<Region>> {
    private final RegionType regionType;

    public InitialLayer(RegistryAccess registryAccess, RegionType regionType) {
        super(InitialLayer.createEntries(registryAccess, regionType));
        this.regionType = regionType;
    }

    @Override
    protected int getEntryIndex(WeightedEntry.Wrapper<Region> entry) {
        return Regions.getIndex(this.regionType, ((Region)entry.m_146310_()).getName());
    }

    private static List<WeightedEntry.Wrapper<Region>> createEntries(RegistryAccess registryAccess, RegionType regionType) {
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        return (List)Regions.get(regionType).stream().filter(region -> {
            AtomicBoolean biomesAdded = new AtomicBoolean(false);
            region.addBiomes((Registry<Biome>)biomeRegistry, pair -> biomesAdded.set(true));
            return region.getType() == regionType && biomesAdded.get();
        }).map(region -> WeightedEntry.m_146290_((Object)region, (int)region.getWeight())).collect(ImmutableList.toImmutableList());
    }
}

