/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import terrablender.api.EndBiomeRegistry;
import terrablender.core.TerraBlender;
import terrablender.worldgen.IExtendedTheEndBiomeSource;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.LayeredNoiseUtil;

@Mixin(value={TheEndBiomeSource.class})
public class MixinTheEndBiomeSource
implements IExtendedTheEndBiomeSource {
    @Shadow
    @Final
    private Holder<Biome> f_48621_;
    @Unique
    private boolean tbInitialized = false;
    @Unique
    private Registry<Biome> biomeRegistry;
    @Unique
    private Set<Holder<Biome>> tbPossibleBiomes;
    @Unique
    private Area highlandsArea;
    @Unique
    private Area midlandsArea;
    @Unique
    private Area edgeArea;
    @Unique
    private Area islandsArea;

    @Override
    public void initializeForTerraBlender(RegistryAccess registryAccess, long seed) {
        this.biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        List<WeightedEntry.Wrapper<ResourceKey<Biome>>> highlands = EndBiomeRegistry.getHighlandsBiomes();
        List<WeightedEntry.Wrapper<ResourceKey<Biome>>> midlands = EndBiomeRegistry.getMidlandsBiomes();
        List<WeightedEntry.Wrapper<ResourceKey<Biome>>> edge = EndBiomeRegistry.getEdgeBiomes();
        List<WeightedEntry.Wrapper<ResourceKey<Biome>>> islands = EndBiomeRegistry.getIslandBiomes();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(highlands.stream().map(WeightedEntry.Wrapper::m_146310_).toList());
        builder.addAll(midlands.stream().map(WeightedEntry.Wrapper::m_146310_).toList());
        builder.addAll(edge.stream().map(WeightedEntry.Wrapper::m_146310_).toList());
        builder.addAll(islands.stream().map(WeightedEntry.Wrapper::m_146310_).toList());
        builder.add((Object)Biomes.f_48210_);
        ImmutableSet allBiomes = builder.build();
        allBiomes.forEach(key -> {
            if (!this.biomeRegistry.m_142003_(key)) {
                throw new RuntimeException("Biome " + key + " has not been registered!");
            }
        });
        this.tbPossibleBiomes = allBiomes.stream().map(arg_0 -> this.biomeRegistry.m_246971_(arg_0)).collect(Collectors.toSet());
        this.highlandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endHighlandsBiomeSize, highlands);
        this.midlandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endMidlandsBiomeSize, midlands);
        this.edgeArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endEdgeBiomeSize, edge);
        this.islandsArea = LayeredNoiseUtil.biomeArea(registryAccess, seed, TerraBlender.CONFIG.endIslandBiomeSize, edge);
        this.tbInitialized = true;
    }

    @Inject(method={"collectPossibleBiomes"}, at={@At(value="RETURN")}, cancellable=true)
    protected void onCollectPossibleBiomes(CallbackInfoReturnable<Stream<Holder<Biome>>> cir) {
        if (!this.tbInitialized) {
            return;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)((Stream)cir.getReturnValue()).collect(Collectors.toSet()));
        builder.addAll(this.tbPossibleBiomes);
        cir.setReturnValue((Object)builder.build().stream());
    }

    @Inject(method={"getNoiseBiome"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetNoiseBiome(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir) {
        int sectionZ;
        if (!this.tbInitialized) {
            return;
        }
        int blockX = QuartPos.m_175402_((int)x);
        int blockY = QuartPos.m_175402_((int)y);
        int blockZ = QuartPos.m_175402_((int)z);
        int sectionX = SectionPos.m_123171_((int)blockX);
        if ((long)sectionX * (long)sectionX + (long)(sectionZ = SectionPos.m_123171_((int)blockZ)) * (long)sectionZ <= 4096L) {
            cir.setReturnValue(this.f_48621_);
        } else {
            double heightNoise = sampler.f_207848_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(blockX, blockY, blockZ));
            if (heightNoise > 0.25) {
                cir.setReturnValue(this.getBiomeHolder(this.highlandsArea.get(x, z)));
            } else if (heightNoise >= -0.0625) {
                cir.setReturnValue(this.getBiomeHolder(this.midlandsArea.get(x, z)));
            } else {
                cir.setReturnValue(heightNoise < -0.21875 ? this.getBiomeHolder(this.islandsArea.get(x, z)) : this.getBiomeHolder(this.edgeArea.get(x, z)));
            }
        }
    }

    @Unique
    private Holder<Biome> getBiomeHolder(int id) {
        return (Holder)this.biomeRegistry.m_203300_(id).orElseThrow();
    }
}

